/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.action;

import hec.gfx2d.AxisLabelDrawProp;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.ViewportDrawProp;
import hec.gfx2d.action.ImportPlotDefaults;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class ExportPlotDefaults {
    String m_lastDirectory = null;

    public void run() throws IOException {
        int reply;
        RMAFilenameFilter zipFileFilter = new RMAFilenameFilter("zip", "Zip File (*.zip)");
        if (this.m_lastDirectory == null) {
            this.m_lastDirectory = Preferences.userRoot().get("Gfx2d/PlotsDefaults/Directory", null);
        }
        if (this.m_lastDirectory == null) {
            this.m_lastDirectory = System.getProperty("user.dir");
        }
        JFileChooser fileChooser = new JFileChooser(this.m_lastDirectory);
        fileChooser.setFileFilter(zipFileFilter);
        int results = fileChooser.showSaveDialog(null);
        if (results == 1) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        Object path = selectedFile.getPath();
        if (!selectedFile.getName().endsWith(".zip")) {
            path = selectedFile.getPath() + ".zip";
            selectedFile = new File((String)path);
        }
        if (selectedFile.exists() && (reply = RMAIO.postYesNoWarning(null, selectedFile.getName() + " already exists!\n Do you want to replace it?")) == 1) {
            return;
        }
        this.m_lastDirectory = selectedFile.getParent();
        Preferences.userRoot().put("Gfx2d/PlotsDefaults/Directory", this.m_lastDirectory);
        this.run(selectedFile);
    }

    public void run(File selectedFile) throws IOException {
        FileOutputStream fstream = new FileOutputStream(selectedFile);
        ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(fstream));
        this.writeProperties(G2dLabelDrawProp.class, zipStream);
        this.writeProperties(TitleDrawProp.class, zipStream);
        this.writeProperties(AxisLabelDrawProp.class, zipStream);
        this.writeProperties(ViewportDrawProp.class, zipStream);
        this.writeProperties(G2dPanelProp.class, zipStream);
        this.writeProperties(LegendPanelProp.class, zipStream);
        this.writeProperties(AxisTicsDrawProp.class, zipStream);
        this.writeProperties(G2dMarkerProperties.class, zipStream);
        zipStream.flush();
        zipStream.finish();
        zipStream.close();
    }

    private void writeProperties(Class c2, ZipOutputStream zipStream) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedWriter buffWriter = new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream));
            Method getFileName = c2.getMethod("getFileName", new Class[0]);
            ZipEntry entry = new ZipEntry((String)getFileName.invoke(null, new Object[0]));
            zipStream.putNextEntry(entry);
            Method writeDefaults = c2.getMethod("writeDefaults", BufferedWriter.class);
            writeDefaults.invoke(null, buffWriter);
            buffWriter.flush();
            zipStream.write(byteArrayOutputStream.toByteArray());
            buffWriter.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Logger.getLogger(ImportPlotDefaults.class.getName()).log(Level.SEVERE, null, e);
            throw new RuntimeException(e.getMessage());
        }
    }
}

