/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.action;

import hec.gfx2d.AxisLabelDrawProp;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.ViewportDrawProp;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import rma.util.RMAFilenameFilter;

public class ImportPlotDefaults {
    String mLastDirectory = null;
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int CANCEL = 2;

    public int run() throws IOException {
        RMAFilenameFilter zipFileFilter = new RMAFilenameFilter("zip", "Zip File (*.zip)");
        if (this.mLastDirectory == null) {
            this.mLastDirectory = Preferences.userRoot().get("Gfx2d/PlotsDefaults/Directory", null);
        }
        if (this.mLastDirectory == null) {
            this.mLastDirectory = System.getProperty("user.dir");
        }
        JFileChooser fileChooser = new JFileChooser(this.mLastDirectory);
        fileChooser.setFileFilter(zipFileFilter);
        int results = fileChooser.showOpenDialog(null);
        if (results == 1) {
            return 2;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile == null || !selectedFile.exists()) {
            return 2;
        }
        this.mLastDirectory = selectedFile.getParent();
        Preferences.userRoot().put("Gfx2d/PlotsDefaults/Directory", this.mLastDirectory);
        this.run(selectedFile);
        return 0;
    }

    public void run(File selectedFile) throws IOException {
        ZipFile zipFile = new ZipFile(selectedFile);
        this.readProperties(G2dLabelDrawProp.class, zipFile);
        this.readProperties(TitleDrawProp.class, zipFile);
        this.readProperties(AxisLabelDrawProp.class, zipFile);
        this.readProperties(ViewportDrawProp.class, zipFile);
        this.readProperties(G2dPanelProp.class, zipFile);
        this.readProperties(LegendPanelProp.class, zipFile);
        this.readProperties(AxisTicsDrawProp.class, zipFile);
        this.readProperties(G2dMarkerProperties.class, zipFile);
    }

    private void readProperties(Class c2, ZipFile zipFile) throws IOException {
        ZipEntry entry = null;
        try {
            Method getFileName = c2.getMethod("getFileName", new Class[0]);
            String fileName = (String)getFileName.invoke(null, new Object[0]);
            entry = zipFile.getEntry(fileName);
            if (entry == null) {
                throw new IOException("Undefined entry in zip file \"" + fileName + "\"");
            }
            InputStream inputStream = zipFile.getInputStream(entry);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader buffReader = new BufferedReader(inputStreamReader);
            Method readDefaults = c2.getMethod("loadDefaults", BufferedReader.class);
            readDefaults.invoke(null, buffReader);
            Method storeDefaults = c2.getMethod("writeDefaults", new Class[0]);
            storeDefaults.invoke(null, new Object[0]);
            buffReader.close();
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(ImportPlotDefaults.class.getName()).log(Level.SEVERE, null, e);
            System.out.println(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Logger.getLogger(ImportPlotDefaults.class.getName()).log(Level.SEVERE, null, e);
            System.out.println(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            Logger.getLogger(ImportPlotDefaults.class.getName()).log(Level.SEVERE, null, e);
            System.out.println(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(ImportPlotDefaults.class.getName()).log(Level.SEVERE, null, e);
            System.out.println(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }
}

