/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.autoload;

import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dObject;
import hec.gfx2d.autoload.EditRefreshOptionsPanel;
import hec.refresh.RefreshEvent;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;

public class AutoLoadManager
implements WindowListener {
    static AutoLoadManager DEFAULT;
    List<G2dDialog> openedWindows = new ArrayList<G2dDialog>();
    Map<G2dDialog, List<G2dObject>> maps = new HashMap<G2dDialog, List<G2dObject>>();
    Map<G2dDialog, Map<G2dObject, Boolean>> updateObjects = new HashMap<G2dDialog, Map<G2dObject, Boolean>>();

    private AutoLoadManager() {
    }

    public static AutoLoadManager getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new AutoLoadManager();
        }
        return DEFAULT;
    }

    public void refreshPlots() {
        this.refreshPlots("");
    }

    public void refreshPlots(String msg) {
        G2dDialog[] dialogs = G2dDialog.getVisibleDialogs().toArray(new G2dDialog[0]);
        for (int i = 0; i < dialogs.length; ++i) {
            G2dDialog dlg = dialogs[i];
            dlg.refresh(new RefreshEvent(this, msg));
        }
    }

    public void editRefreshProperties(G2dDialog dlg) {
        Map<G2dObject, Boolean> updateObjectMap = this.updateObjects.get(dlg);
        if (updateObjectMap == null) {
            Vector plotObjects = dlg.getPlotpanel().getPlotObjects();
            updateObjectMap = new HashMap<G2dObject, Boolean>();
            for (int i = 0; i < plotObjects.size(); ++i) {
                updateObjectMap.put((G2dObject)plotObjects.get(i), Boolean.TRUE);
            }
            this.updateObjects.put(dlg, updateObjectMap);
        }
        EditRefreshOptionsPanel panel = new EditRefreshOptionsPanel();
        panel.setData(updateObjectMap);
        JDialog dialog = new JDialog(dlg);
        dialog.add("Center", panel);
        dialog.setTitle("Edit Refresh Options: " + dlg.getTitle());
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        Window w = e.getWindow();
        if (w == null || !(w instanceof G2dDialog)) {
            return;
        }
        if (!this.openedWindows.contains(w)) {
            this.openedWindows.add((G2dDialog)w);
            G2dDialog dlg = (G2dDialog)w;
            Vector plotObjects = dlg.getPlotpanel().getPlotObjects();
            ArrayList<G2dObject> plotObjects2 = new ArrayList<G2dObject>();
            HashMap<G2dObject, Boolean> updateMap = new HashMap<G2dObject, Boolean>();
            for (int i = 0; i < plotObjects.size(); ++i) {
                Object object = plotObjects.get(i);
                plotObjects2.add((G2dObject)object);
                updateMap.put((G2dObject)object, Boolean.TRUE);
            }
            this.updateObjects.put(dlg, updateMap);
            this.maps.put(dlg, plotObjects2);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        Window w = e.getWindow();
        if (w == null || !(w instanceof G2dDialog)) {
            return;
        }
        this.openedWindows.remove(w);
        this.maps.remove(w);
        this.updateObjects.remove(w);
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    static {
        AutoLoadManager manager = AutoLoadManager.getDefault();
        G2dDialog.addG2dDialogWindowListener(manager);
        DEFAULT = null;
    }
}

