/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.autoload;

import hec.gfx2d.G2dObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class EditRefreshTableModel
extends AbstractTableModel {
    Map<G2dObject, Boolean> plotObjects = null;
    Map.Entry<G2dObject, Boolean>[] dataArray;
    List<Boolean> selectionCache = Collections.EMPTY_LIST;

    public void setData(Map<G2dObject, Boolean> plotObjects) {
        this.plotObjects = plotObjects;
        Set<Map.Entry<G2dObject, Boolean>> dataSet = plotObjects.entrySet();
        int items = dataSet.size();
        this.dataArray = new Map.Entry[items];
        this.selectionCache = new ArrayList<Boolean>(items);
        Iterator<Map.Entry<G2dObject, Boolean>> iterator = dataSet.iterator();
        int idx = 0;
        while (iterator.hasNext()) {
            this.dataArray[idx++] = iterator.next();
            this.selectionCache.add(null);
        }
        this.fireTableDataChanged();
    }

    public void selectAll(boolean select) {
        for (int i = 0; i < this.selectionCache.size(); ++i) {
            this.selectionCache.set(i, select);
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? "Select" : "Plot Object";
    }

    @Override
    public int getRowCount() {
        return this.plotObjects != null ? this.plotObjects.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Boolean bValue = this.selectionCache.get(rowIndex);
        bValue = bValue != null ? bValue : this.dataArray[rowIndex].getValue();
        return columnIndex == 0 ? bValue : this.dataArray[rowIndex].getKey().toString();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return;
        }
        Boolean value = aValue != null ? Boolean.parseBoolean(aValue.toString()) : Boolean.FALSE;
        this.selectionCache.set(rowIndex, value);
    }

    public void commitData() {
        for (int i = 0; i < this.selectionCache.size(); ++i) {
            Boolean boolean1 = this.selectionCache.get(i);
            if (boolean1 == null) continue;
            this.dataArray[i].setValue(boolean1);
        }
    }
}

