/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class EdgeBorder
implements Border {
    private Insets a = new Insets(2, 2, 2, 2);
    private int m_edgePattern = 65535;
    public static final int EDGE_RIGHT = 61440;
    public static final int EDGE_BOTTOM = 3840;
    public static final int EDGE_LEFT = 240;
    public static final int EDGE_TOP = 15;
    public static final int EDGE_ALL = 65535;

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.a;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
        Color shadow = component.getBackground().darker();
        Color highlight = component.getBackground().brighter();
        Color oldColor = graphics.getColor();
        if ((this.m_edgePattern & 0xF) != 0) {
            graphics.setColor(shadow);
            graphics.drawLine(x, y, x + width - 1, y);
            graphics.setColor(highlight);
            graphics.drawLine(x, y + 1, x + width - 1, y + 1);
        }
        if ((this.m_edgePattern & 0xF0) != 0) {
            graphics.setColor(shadow);
            graphics.drawLine(x, y, x, y + height - 1);
            graphics.setColor(highlight);
            graphics.drawLine(x + 1, y, x + 1, y + height - 1);
        }
        if ((this.m_edgePattern & 0xF00) != 0) {
            graphics.setColor(shadow);
            graphics.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
            graphics.setColor(highlight);
            graphics.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        }
        if ((this.m_edgePattern & 0xF000) != 0) {
            graphics.setColor(shadow);
            graphics.drawLine(x + width - 2, y, x + width - 2, y + height - 1);
            graphics.setColor(highlight);
            graphics.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        }
        graphics.setColor(oldColor);
    }

    public EdgeBorder(int i) {
        this.m_edgePattern = i;
        this.recalcInsets();
    }

    public EdgeBorder() {
    }

    protected void recalcInsets() {
        this.a.top = (this.m_edgePattern & 0xF) != 0 ? 2 : 0;
        this.a.left = (this.m_edgePattern & 0xF0) != 0 ? 2 : 0;
        this.a.bottom = (this.m_edgePattern & 0xF00) != 0 ? 2 : 0;
        this.a.right = (this.m_edgePattern & 0xF000) != 0 ? 2 : 0;
    }
}

