/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.components;

import hec.gfx2d.SamplePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;

public class FontPanel
extends EnabledJPanel {
    private RmaJComboBox<String> _fontCombo;
    private RmaJCheckBox _boldCheck;
    private RmaJCheckBox _italicCheck;
    private RmaJCheckBox _underlineCheck;
    private RmaJColorComboBox _colorCombo;
    private RmaJComboBox _sizeCombo;
    private RmaJCheckBox _useScalingCheck;
    private JPanel _scalingPanel;
    private RmaJComboBox _minSizeCombo;
    private RmaJComboBox _maxSizeCombo;
    private JPanel _samplePanel;
    private int _minFontSize = 5;
    private int _maxFontSize = 96;

    public FontPanel(Font font) {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
        this.setSelectedFont(font);
    }

    protected void buildControls() {
        this.setBorder(BorderFactory.createTitledBorder("Font"));
        JLabel label = new JLabel("Font:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)label, gbc);
        this._fontCombo = new RmaJComboBox<String>(new RmaListModel<String>(true, this.getFontList()));
        this._fontCombo.setModifiable(true);
        label.setLabelFor(this._fontCombo);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add(this._fontCombo, gbc);
        label = new JLabel("Style:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)label, gbc);
        JPanel stylePanel = new JPanel(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0000;
        this.add((Component)stylePanel, gbc);
        this._boldCheck = new RmaJCheckBox("Bold");
        this._boldCheck.setMnemonic('B');
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        stylePanel.add((Component)this._boldCheck, gbc);
        this._italicCheck = new RmaJCheckBox("Italic");
        this._italicCheck.setMnemonic('I');
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        stylePanel.add((Component)this._italicCheck, gbc);
        label = new JLabel("Color");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)label, gbc);
        this._colorCombo = new RmaJColorComboBox();
        this._colorCombo.setModifiable(true);
        label.setLabelFor(this._colorCombo);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._colorCombo, gbc);
        label = new JLabel("Size:");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)label, gbc);
        Integer[] sizes = this.getFontSizes();
        this._sizeCombo = new RmaJComboBox<Integer>(sizes);
        this._sizeCombo.setModifiable(true);
        label.setLabelFor(this._sizeCombo);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._sizeCombo, gbc);
        this._useScalingCheck = new RmaJCheckBox("Use Font Scaling");
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._useScalingCheck, gbc);
        this._scalingPanel = new EnabledJPanel(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._scalingPanel, gbc);
        label = new JLabel("Min Size:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._scalingPanel.add((Component)label, gbc);
        this._minSizeCombo = new RmaJComboBox<Integer>(sizes);
        this._minSizeCombo.setModifiable(true);
        label.setLabelFor(this._minSizeCombo);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._scalingPanel.add((Component)this._minSizeCombo, gbc);
        label = new JLabel("Max Size:");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._scalingPanel.add((Component)label, gbc);
        this._maxSizeCombo = new RmaJComboBox<Integer>(sizes);
        this._maxSizeCombo.setModifiable(true);
        label.setLabelFor(this._minSizeCombo);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._scalingPanel.add((Component)this._maxSizeCombo, gbc);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FontPanel.this.fontScaleCheckAction();
            }
        });
    }

    private Integer[] getFontSizes() {
        Integer[] sizes = new Integer[this._maxFontSize - this._minFontSize + 1];
        for (int i = this._minFontSize; i <= this._maxFontSize; ++i) {
            sizes[i - this._minFontSize] = i;
        }
        return sizes;
    }

    private void addListeners() {
        this._useScalingCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontPanel.this.fontScaleCheckAction();
            }
        });
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontPanel.this.updateSamplePanel();
            }
        };
        this._boldCheck.addActionListener(al);
        this._italicCheck.addActionListener(al);
        this._fontCombo.addActionListener(al);
        this._sizeCombo.addActionListener(al);
        this._colorCombo.addActionListener(al);
    }

    protected void updateSamplePanel() {
        if (this._samplePanel == null) {
            return;
        }
        Font f = this.getSelectedFont();
        this._samplePanel.setFont(f);
        if (this._samplePanel instanceof SamplePanel) {
            ((SamplePanel)this._samplePanel).setTextSize(f.getSize());
            ((SamplePanel)this._samplePanel).setTextForeground(this._colorCombo.getSelectedColor());
        }
        this._samplePanel.repaint();
    }

    protected void fontScaleCheckAction() {
        this._scalingPanel.setEnabled(this._useScalingCheck.isSelected());
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            return;
        }
        Integer size = font.getSize();
        this._sizeCombo.setSelectedItem(size);
        String s = font.getFamily();
        if (((RmaListModel)this._fontCombo.getModel()).indexOf(s) == -1) {
            int cnt = this._fontCombo.getItemCount();
            for (int i = 0; i < cnt; ++i) {
                if (!s.equalsIgnoreCase(((String)this._fontCombo.getItemAt(i)).toString())) continue;
                this._fontCombo.setSelectedIndex(i);
                break;
            }
        } else {
            this._fontCombo.setSelectedItem(s);
        }
        this._boldCheck.setSelected(font.isBold());
        this._italicCheck.setSelected(font.isItalic());
    }

    public Font getSelectedFont() {
        int style = 0;
        if (this._boldCheck.isSelected()) {
            style |= 1;
        }
        if (this._italicCheck.isSelected()) {
            style |= 2;
        }
        int size = (Integer)this._sizeCombo.getSelectedItem();
        Font f = new Font((String)this._fontCombo.getSelectedItem(), style, size);
        return f;
    }

    public boolean useFontScaling() {
        return this._useScalingCheck.isSelected();
    }

    public int getMinScalingSize() {
        Integer i = (Integer)this._minSizeCombo.getSelectedItem();
        return i;
    }

    public int getMaxScalingSize() {
        Integer i = (Integer)this._maxSizeCombo.getSelectedItem();
        return i;
    }

    public void setUseFontScaling(boolean useIt) {
        this._useScalingCheck.setSelected(useIt);
        this.fontScaleCheckAction();
    }

    public void setMinScalingSize(int size) {
        Integer i = size;
        this._minSizeCombo.setSelectedItem(i);
    }

    public void setMaxScalingSize(int size) {
        Integer i = size;
        this._maxSizeCombo.setSelectedItem(i);
    }

    private String[] getFontList() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public void setSamplePanel(JPanel samplePanel) {
        this._samplePanel = samplePanel;
    }

    public void setFontColor(Color textColor) {
        this._colorCombo.setSelectedColor(textColor);
    }

    public Color getFontColor() {
        return this._colorCombo.getSelectedColor();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fontScaleCheckAction();
    }

    public void setMinimumFontSize(int minFontSize) {
        this._minFontSize = minFontSize;
        this._sizeCombo.setModel(new RmaListModel<Integer>(true, this.getFontSizes()));
    }

    public void setMaximumFontSize(int maxFontSize) {
        this._maxFontSize = maxFontSize;
        this._sizeCombo.setModel(new RmaListModel<Integer>(true, this.getFontSizes()));
    }

    public void setFontScalingAvailable(boolean available) {
        this._scalingPanel.setVisible(available);
        this._useScalingCheck.setVisible(available);
    }
}

