/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTextField;
import rma.util.RMAUtil;

public class IconPanel
extends EnabledJPanel {
    private RmaJTextField _fileFld;
    private RmaJComboBox _positionCombo;
    private JButton _fileSelecteBtn;

    public IconPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this.setBorder(BorderFactory.createTitledBorder("Icon"));
        JLabel label = new JLabel("File:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)label, gbc);
        this._fileFld = new RmaJTextField();
        label.setLabelFor(this._fileFld);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._fileFld, gbc);
        this._fileSelecteBtn = new JButton(new FileChooserAction(this._fileFld));
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5005;
        this.add((Component)this._fileSelecteBtn, gbc);
        label = new JLabel("Position:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)label, gbc);
        String[] positions = new String[]{"Top Left", "Top Center", "Top Right"};
        this._positionCombo = new RmaJComboBox<String>(positions);
        this._positionCombo.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._positionCombo, gbc);
    }

    public void setPath(String iconPath) {
        if (iconPath == null) {
            this._fileFld.setText("");
            return;
        }
        this._fileFld.setText(iconPath);
    }

    public String getPath() {
        return this._fileFld.getText();
    }

    private class FileChooserAction
    extends AbstractAction {
        JTextField _field = null;

        public FileChooserAction(JTextField f) {
            this._field = f;
            this.putValue("Name", "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser;
            String currentDir;
            String string = currentDir = this._field != null ? this._field.getText() : "";
            if (currentDir != null && currentDir.length() > 0) {
                int index = currentDir.lastIndexOf("/");
                if (index < 0) {
                    index = currentDir.lastIndexOf("\\");
                }
                if (index < 0) {
                    fileChooser = new JFileChooser();
                } else {
                    currentDir = currentDir.substring(0, index);
                    fileChooser = new JFileChooser(currentDir);
                }
            } else {
                fileChooser = new JFileChooser();
            }
            int results = fileChooser.showOpenDialog(IconPanel.this);
            if (results != 0) {
                return;
            }
            File f = fileChooser.getSelectedFile();
            if (f == null) {
                return;
            }
            if (this._field != null) {
                this._field.setText(f.getAbsolutePath());
                RMAUtil.setParentModified(IconPanel.this);
            }
        }
    }
}

