/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.components;

import hec.gfx2d.G2dFont;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.LabelLayoutConstants;
import hec.gfx2d.components.CheckBoxPanel;
import hec.gfx2d.components.ComponentPanel;
import hec.gfx2d.components.FontPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTextField;

public class LabelPanel
extends DefaultJPanel
implements ComponentPanel {
    private CheckBoxPanel _checkBoxPanel;
    private FontPanel _fontPanel;
    private RmaJTextField _labelText;
    private RmaJComboBox _alignmentCombo;
    private RmaJComboBox _positionCombo;
    private JLabel _textLabel;
    private JLabel _alignLabel;
    private JLabel _positionLabel;
    private G2dLabelDrawProp _properties;
    private JPanel _samplePanel;

    public LabelPanel(String checkBoxText) {
        super(new GridBagLayout());
        this.buildControls(checkBoxText);
        this.addListeners();
    }

    protected void buildControls(String checkBoxText) {
        this.setBorder(BorderFactory.createTitledBorder("Label"));
        this._checkBoxPanel = new CheckBoxPanel(checkBoxText);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._checkBoxPanel, gbc);
        this._textLabel = new JLabel("Text:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._textLabel, gbc);
        this._labelText = new RmaJTextField();
        this._textLabel.setLabelFor(this._labelText);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._labelText, gbc);
        this._fontPanel = new FontPanel(null);
        this._fontPanel.setBorder(BorderFactory.createTitledBorder("Font"));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._fontPanel, gbc);
        this._alignLabel = new JLabel("Alignment:");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._alignLabel, gbc);
        this._alignmentCombo = new RmaJComboBox<String>(LabelLayoutConstants.LABEL_ALIGN_NAMES);
        this._alignmentCombo.setModifiable(true);
        this._alignLabel.setLabelFor(this._alignmentCombo);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._alignmentCombo, gbc);
        this._positionLabel = new JLabel("Position:");
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._positionLabel, gbc);
        this._positionCombo = new RmaJComboBox<String>(LabelLayoutConstants.LABEL_POS_NAMES);
        this._positionLabel.setLabelFor(this._positionCombo);
        this._positionCombo.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._positionCombo, gbc);
    }

    protected void addListeners() {
        this._checkBoxPanel.addComponentPanel(this);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelPanel.this.updateSamplePanel();
            }
        };
        this._alignmentCombo.addActionListener(al);
        this._positionCombo.addActionListener(al);
    }

    protected void updateSamplePanel() {
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        this._fontPanel.setEnabled(enabled);
        this._labelText.setEnabled(enabled);
        this._alignmentCombo.setEnabled(enabled);
        this._positionCombo.setEnabled(enabled);
        this._textLabel.setEnabled(enabled);
        this._alignLabel.setEnabled(enabled);
        this._positionLabel.setEnabled(enabled);
        this.updateSamplePanel();
    }

    public void setData(G2dLabelDrawProp properties) {
        this._properties = properties;
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        this._labelText.setText(this._properties.text);
        this._fontPanel.setSelectedFont(this._properties.font);
        this._alignmentCombo.setSelectedIndex(this._properties.align);
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        this._properties.text = this._labelText.getText();
        this._properties.font = this._fontPanel.getSelectedFont();
        this._properties.align = this._alignmentCombo.getSelectedIndex();
        return true;
    }

    public void setSelected(boolean selected) {
        this._checkBoxPanel.setSelected(selected);
    }

    public boolean isSelected() {
        return this._checkBoxPanel.isSelected();
    }

    public void setSamplePanel(JPanel samplePanel) {
        this._samplePanel = samplePanel;
        this._fontPanel.setSamplePanel(samplePanel);
    }

    public void setSelectedFont(Font labelFont) {
        this._fontPanel.setSelectedFont(labelFont);
    }

    public Font getSelectedFont() {
        return this._fontPanel.getSelectedFont();
    }

    public void setText(String label) {
        if (label == null) {
            this._labelText.setText("");
            return;
        }
        this._labelText.setText(label);
    }

    public String getText() {
        return this._labelText.getText();
    }

    public void setAlignment(int labelAlignment) {
        this._alignmentCombo.setSelectedIndex(labelAlignment);
    }

    public int getAlignment() {
        return this._alignmentCombo.getSelectedIndex();
    }

    public void setPosition(int labelPosition) {
        this._positionCombo.setSelectedIndex(labelPosition);
    }

    public int getPosition() {
        return this._positionCombo.getSelectedIndex();
    }

    public void setTextColor(Color labelColor) {
        this._fontPanel.setFontColor(labelColor);
    }

    public Color getTextColor() {
        return this._fontPanel.getFontColor();
    }

    public String getPositionString() {
        return (String)this._positionCombo.getSelectedItem();
    }

    public String getAlignmentString() {
        return (String)this._alignmentCombo.getSelectedItem();
    }

    public void clearPanel() {
        this._checkBoxPanel.setSelected(false);
        this._fontPanel.setSelectedFont(G2dFont.newFont("Dialog", 0, 12));
        this._labelText.setText("");
        this._alignmentCombo.setSelectedIndex(0);
        this._positionCombo.setSelectedIndex(0);
        this._positionLabel.setText("");
    }

    public void setLabelTextVisible(boolean visible) {
        this._textLabel.setVisible(visible);
        this._labelText.setVisible(visible);
    }
}

