/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.components;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.components.ComponentPanel;
import hec.gfx2d.components.SimplePointPropertiesPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJRadioButton;
import rma.util.RMAIO;

public class LinePointPropertiesPanel
extends SimplePointPropertiesPanel
implements ComponentPanel,
ActionListener {
    RmaJRadioButton autoSkipRadio;
    RmaJRadioButton drawDataPtsRadio;
    RmaJIntegerField skipPtsTxt;
    RmaJIntegerField offsetPtsTxt;
    RmaJIntegerField intervalPtsTxt;
    RmaJIntegerField offsetIntervalTxt;
    JLabel skipPtsLbl;
    JLabel offsetPtsLbl;
    JLabel intervalPtsLbl;
    JLabel offsetIntervalLbl;
    private JComponent _samplePanel;
    private G2dLineProperties _properties;

    public LinePointPropertiesPanel(JComponent samplePanel) {
        super(samplePanel);
        this._samplePanel = samplePanel;
    }

    @Override
    protected void buildControls() {
        super.buildControls();
        this.skipPtsLbl = new JLabel("Skip");
        this.offsetPtsLbl = new JLabel("Offset");
        this.intervalPtsLbl = new JLabel("Interval");
        this.offsetIntervalLbl = new JLabel("Offset");
        this.autoSkipRadio = new RmaJRadioButton("Automatic Symbol Drawing");
        this.drawDataPtsRadio = new RmaJRadioButton("Draw Symbols on Data Points");
        this.skipPtsTxt = new RmaJIntegerField();
        this.offsetPtsTxt = new RmaJIntegerField();
        this.intervalPtsTxt = new RmaJIntegerField();
        this.offsetIntervalTxt = new RmaJIntegerField();
        ButtonGroup drawPtsGroup = new ButtonGroup();
        drawPtsGroup.add(this.drawDataPtsRadio);
        drawPtsGroup.add(this.autoSkipRadio);
        this.drawDataPtsRadio.setSelected(true);
        JPanel drawPtsPanel = new JPanel(new GridBagLayout());
        this.drawDataPtsRadio.setMargin(new Insets(0, 0, 0, 0));
        this.autoSkipRadio.setMargin(new Insets(0, 0, 0, 0));
        drawPtsPanel.add((Component)this.autoSkipRadio, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        drawPtsPanel.add((Component)this.drawDataPtsRadio, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        drawPtsPanel.add((Component)this.skipPtsLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 25, 0, 0), 0, 0));
        drawPtsPanel.add((Component)this.skipPtsTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 15), 0, 0));
        drawPtsPanel.add((Component)this.offsetPtsLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 25, 0, 0), 0, 0));
        drawPtsPanel.add((Component)this.offsetPtsTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 15), 0, 0));
        this.pointStylePanel.add((Component)drawPtsPanel, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.drawDataPtsRadio.addActionListener(this);
        this.autoSkipRadio.addActionListener(this);
        this.drawDataPointsOffsets(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.drawDataPtsRadio) {
            this.drawDataPointsOffsets(true);
        } else if (o == this.autoSkipRadio) {
            this.drawAutoSkipPoints(true);
        }
    }

    @Override
    public void fillPanel() {
        if (this._properties == null) {
            return;
        }
        super.fillPanel();
        if (this._properties.drawPoints()) {
            this.setSelected(true);
            if (this._properties.getDrawOnPoints()) {
                this.drawDataPtsRadio.doClick();
                int skip = this._properties.getSkipPoints() == Integer.MIN_VALUE ? 0 : this._properties.getSkipPoints();
                int offset = this._properties.getOffsetPoint() == Integer.MIN_VALUE ? 0 : this._properties.getOffsetPoint();
                this.skipPtsTxt.setText(RMAIO.toTable(skip));
                this.offsetPtsTxt.setText(RMAIO.toTable(offset));
            } else if (this._properties.getAutoSkipPoints()) {
                this.autoSkipRadio.doClick();
            }
        } else {
            this.setSelected(false);
        }
        this.setPointStyle(this._properties.getSymbolType());
        this.setPointSize((int)this._properties.getSymbolSize());
        this.setPointFillColor(this._properties.getPointFillColor());
        this.setPointLineColor(this._properties.getPointLineColor());
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        super.setComponentsEnabled(enabled);
        this.autoSkipRadio.setEnabled(enabled);
        this.drawDataPtsRadio.setEnabled(enabled);
        this.offsetIntervalLbl.setEnabled(enabled);
        this.offsetIntervalTxt.setEnabled(enabled);
        this.offsetPtsLbl.setEnabled(enabled);
        this.offsetPtsTxt.setEnabled(enabled);
        this.skipPtsLbl.setEnabled(enabled);
        this.skipPtsTxt.setEnabled(enabled);
        this.intervalPtsLbl.setEnabled(enabled);
        this.intervalPtsTxt.setEnabled(enabled);
        if (enabled && this.drawDataPtsRadio.isSelected()) {
            this.drawDataPtsRadio.doClick();
        }
        this._samplePanel.repaint();
    }

    private void drawDataPointsOffsets(boolean enabled) {
        this.skipPtsLbl.setEnabled(enabled);
        this.skipPtsTxt.setEnabled(enabled);
        this.offsetPtsLbl.setEnabled(enabled);
        this.offsetPtsTxt.setEnabled(enabled);
        this.offsetIntervalLbl.setEnabled(!enabled);
        this.offsetIntervalTxt.setEnabled(!enabled);
        this.intervalPtsLbl.setEnabled(!enabled);
        this.intervalPtsTxt.setEnabled(!enabled);
    }

    private void drawAutoSkipPoints(boolean enabled) {
        this.skipPtsLbl.setEnabled(!enabled);
        this.skipPtsTxt.setEnabled(!enabled);
        this.offsetPtsLbl.setEnabled(!enabled);
        this.offsetPtsTxt.setEnabled(!enabled);
        this.offsetIntervalLbl.setEnabled(!enabled);
        this.offsetIntervalTxt.setEnabled(!enabled);
        this.intervalPtsLbl.setEnabled(!enabled);
        this.intervalPtsTxt.setEnabled(!enabled);
    }

    public void setData(G2dLineProperties prop) {
        this._properties = prop;
    }

    public G2dLineProperties getData() {
        return this._properties;
    }

    @Override
    public boolean savePanel() {
        if (this._properties == null) {
            return true;
        }
        this._properties.setDrawPoints(this.isSelected());
        int symbolType = this.getPointStyle();
        this._properties.setSymbolType(symbolType);
        this._properties.setSymbolFillColor(this.getPointFillColor());
        this._properties.setSymbolLineColor(this.getPointLineColor());
        this._properties.setSymbolSize(this.getPointSize());
        if (this.drawDataPtsRadio.isSelected() && this.isSelected()) {
            this._properties.setAutoSkipPoints(false);
            this._properties.setDrawOnPoints(this.drawDataPtsRadio.isSelected());
            int skip = RMAIO.parseInt(this.skipPtsTxt.getText());
            int offset = RMAIO.parseInt(this.offsetPtsTxt.getText());
            this._properties.setSkipPoints(skip == Integer.MIN_VALUE ? 0 : skip);
            this._properties.setOffsetPoint(offset == Integer.MIN_VALUE ? 0 : offset);
        } else if (this.autoSkipRadio.isSelected() && this.isSelected()) {
            this._properties.setDrawOnPoints(false);
            this._properties.setAutoSkipPoints(true);
        }
        return false;
    }

    public boolean validatePanel() {
        int skip = RMAIO.parseInt(this.skipPtsTxt.getText());
        int offset = RMAIO.parseInt(this.offsetPtsTxt.getText());
        if (skip < 0 && skip != Integer.MIN_VALUE && this.isSelected()) {
            RMAIO.postError(this, "You cannont skip a negative number of data points");
            return false;
        }
        if (offset < 0 && offset != Integer.MIN_VALUE && this.isSelected()) {
            RMAIO.postError(this, "You cannot have a negative data point offset");
            return false;
        }
        return true;
    }
}

