/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.components;

import hec.gfx2d.G2dFillPatternRenderer;
import hec.gfx2d.SimpleLinePropertiesPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJRadioButton;
import rma.swing.table.RmaColorRenderer;

public class LinePropertiesPanel
extends SimpleLinePropertiesPanel {
    private RmaJRadioButton _lineFillAboveRadio;
    private RmaJRadioButton _lineFillBelowRadio;
    private RmaJRadioButton _lineFillNoneRadio;
    private RmaJColorComboBox _lineFillColorCombo;
    private RmaJComboBox _lineFillPatternCombo;
    private JLabel _lineFillColorLabel;
    private JLabel _lineFillPatternLabel;

    public LinePropertiesPanel(String checkBoxLabel) {
        super(checkBoxLabel);
    }

    @Override
    protected void buildControls(String checkboxLabel) {
        super.buildControls(checkboxLabel);
        GridBagLayout gbl = (GridBagLayout)this.getLayout();
        GridBagConstraints gbc = gbl.getConstraints(this.jWeightCombo);
        gbc.weighty = 0.0;
        gbl.setConstraints(this.jWeightCombo, gbc);
        gbc = gbl.getConstraints(this.weightLabel);
        gbc.weighty = 0.0;
        gbl.setConstraints(this.weightLabel, gbc);
        this.setBorder(BorderFactory.createTitledBorder("Line"));
        JPanel fillPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this.add((Component)fillPanel, gbc);
        JLabel label = new JLabel("Fill:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 10, 0, 5);
        fillPanel.add((Component)label, gbc);
        this._lineFillNoneRadio = new RmaJRadioButton("None", true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        fillPanel.add((Component)this._lineFillNoneRadio, gbc);
        this._lineFillBelowRadio = new RmaJRadioButton("Below");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        fillPanel.add((Component)this._lineFillBelowRadio, gbc);
        this._lineFillAboveRadio = new RmaJRadioButton("Above");
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        fillPanel.add((Component)this._lineFillAboveRadio, gbc);
        this._lineFillColorLabel = new JLabel("Fill Color:");
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 25, 0, 5);
        this.add((Component)this._lineFillColorLabel, gbc);
        this._lineFillColorCombo = new RmaJColorComboBox();
        this._lineFillColorCombo.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._lineFillColorCombo, gbc);
        this._lineFillPatternLabel = new JLabel("Fill Pattern:");
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 25, 0, 5);
        this.add((Component)this._lineFillPatternLabel, gbc);
        this._lineFillPatternCombo = new RmaJComboBox();
        this._lineFillPatternCombo.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._lineFillPatternCombo, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._lineFillAboveRadio);
        bg.add(this._lineFillNoneRadio);
        bg.add(this._lineFillBelowRadio);
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(4), new Integer(3), new Integer(5), new Integer(6)});
        this._lineFillPatternCombo.setModel(comboModel);
        this._lineFillPatternCombo.setRenderer(new G2dFillPatternRenderer());
        this.fillRadioAction();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinePropertiesPanel.this.fillRadioAction();
            }
        };
        this._lineFillAboveRadio.addActionListener(al);
        this._lineFillNoneRadio.addActionListener(al);
        this._lineFillBelowRadio.addActionListener(al);
        this._lineFillColorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinePropertiesPanel.this.updateFillPatternCombo();
            }
        });
        this._lineFillPatternCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinePropertiesPanel.this.updateSamplePanel();
            }
        });
    }

    protected void updateFillPatternCombo() {
        Color clr = this._lineFillColorCombo.getSelectedColor();
        ((G2dFillPatternRenderer)this._lineFillPatternCombo.getRenderer()).setColor(clr);
        this.updateSamplePanel();
    }

    protected void fillRadioAction() {
        boolean enabled = !this._lineFillNoneRadio.isSelected();
        this._lineFillColorCombo.setEnabled(enabled);
        this._lineFillPatternCombo.setEnabled(enabled);
        this._lineFillColorLabel.setEnabled(enabled);
        this._lineFillPatternLabel.setEnabled(enabled);
        this.updateSamplePanel();
    }

    protected void updateSamplePanel() {
        if (this._samplePanel != null) {
            this._samplePanel.repaint();
        }
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        super.setComponentsEnabled(enabled);
        this._lineFillAboveRadio.setEnabled(enabled);
        this._lineFillBelowRadio.setEnabled(enabled);
        this._lineFillNoneRadio.setEnabled(enabled);
        this._lineFillColorCombo.setEnabled(enabled);
        this._lineFillPatternCombo.setEnabled(enabled);
        this._lineFillColorLabel.setEnabled(enabled);
        this._lineFillPatternLabel.setEnabled(enabled);
        this.fillRadioAction();
    }

    public void setFillColor(Color fillColor) {
        this._lineFillColorCombo.setSelectedColor(fillColor);
        ((G2dFillPatternRenderer)this._lineFillPatternCombo.getRenderer()).setColor(fillColor);
    }

    public Color getFillColor() {
        return this._lineFillColorCombo.getSelectedColor();
    }

    public void setFillType(int fillType) {
        switch (fillType) {
            case 0: {
                this._lineFillNoneRadio.doClick();
                break;
            }
            case 1: {
                this._lineFillAboveRadio.doClick();
                break;
            }
            case 2: {
                this._lineFillBelowRadio.doClick();
            }
        }
    }

    public int getFillType() {
        if (this._lineFillBelowRadio.isSelected()) {
            return 2;
        }
        if (this._lineFillAboveRadio.isSelected()) {
            return 1;
        }
        return 0;
    }

    public void setFillPattern(int fillPattern) {
        this._lineFillPatternCombo.setSelectedItem(new Integer(fillPattern));
    }

    public int getFillPattern() {
        return (Integer)this._lineFillPatternCombo.getSelectedItem();
    }

    @Override
    public void clearPanel() {
        super.clearPanel();
        this._lineFillNoneRadio.setSelected(true);
        this._lineFillColorCombo.setSelectedColor(Color.blue);
        this._lineFillPatternCombo.setSelectedIndex(0);
    }

    public void setRenderColorNames(boolean b) {
        super.setRendererColorNames(b);
        ((RmaColorRenderer)this._lineFillColorCombo.getRenderer()).setRenderColorName(b);
    }
}

