/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.components;

import hec.gfx2d.G2dSymbolRenderer;
import hec.gfx2d.Symbol;
import hec.gfx2d.components.CheckBoxPanel;
import hec.gfx2d.components.ComponentPanel;
import hec.gfx2d.components.G2dDefaultJPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.RmaIntegerJSpinBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;

public class SimplePointPropertiesPanel
extends G2dDefaultJPanel
implements ComponentPanel,
ActionListener {
    Object[] pLineCustomColor = new Object[]{Color.white, "Custom"};
    Object[] pFillCustomColor = new Object[]{Color.white, "Custom"};
    private CheckBoxPanel checkBoxPanel;
    protected JPanel pointStylePanel;
    private JLabel pointStyleLabel;
    private JLabel pointFillColorLabel;
    private JLabel pointLineColorLabel;
    private RmaJComboBox pointStyleCombo;
    private RmaJColorComboBox pointFillColorCombo;
    private RmaJColorComboBox pointLineColorCombo;
    private JLabel pointSizeLabel;
    private RmaIntegerJSpinBox sizeSpinBox;
    private JComponent _samplePanel;

    public SimplePointPropertiesPanel(JComponent samplePanel) {
        super(new GridBagLayout());
        this._samplePanel = samplePanel;
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this.checkBoxPanel = new CheckBoxPanel("Draw Points");
        this.checkBoxPanel.setSelected(true);
        this.pointStyleLabel = new JLabel("Style:");
        this.pointStylePanel = new JPanel(new GridBagLayout());
        this.pointFillColorLabel = new JLabel("Fill Color:");
        this.pointLineColorLabel = new JLabel("Line Color:");
        this.pointStyleCombo = new RmaJComboBox();
        this.pointStyleCombo.setModifiable(true);
        this.pointFillColorCombo = new RmaJColorComboBox();
        this.pointFillColorCombo.setModifiable(true);
        this.pointLineColorCombo = new RmaJColorComboBox();
        this.pointLineColorCombo.setModifiable(true);
        this.pointSizeLabel = new JLabel("Size:");
        this.sizeSpinBox = new RmaIntegerJSpinBox();
        this.sizeSpinBox.setMaximum(45);
        this.sizeSpinBox.setMinimum(1);
        this.sizeSpinBox.setValue(10);
        this.pointStylePanel.add((Component)this.checkBoxPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.pointStylePanel.add((Component)this.pointStyleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.pointStylePanel.add((Component)this.pointStyleCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pointStylePanel.add((Component)this.pointLineColorLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.pointStylePanel.add((Component)this.pointLineColorCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pointStylePanel.add((Component)this.pointFillColorLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.pointStylePanel.add((Component)this.pointFillColorCombo, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.pointStylePanel.add((Component)this.pointSizeLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.pointStylePanel.add((Component)this.sizeSpinBox, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 15, 0));
        Integer[] symbolTypes = new Integer[Symbol.numSymbols()];
        for (int i = 0; i < Symbol.numSymbols(); ++i) {
            symbolTypes[i] = new Integer(i);
        }
        DefaultComboBoxModel<Integer> comboModel = new DefaultComboBoxModel<Integer>(symbolTypes);
        this.pointStyleCombo.setModel(comboModel);
        this.pointStyleCombo.setRenderer(new G2dSymbolRenderer(Color.blue, Color.blue));
        this.pointFillColorCombo.addItem(this.pFillCustomColor);
        this.pointLineColorCombo.addItem(this.pLineCustomColor);
        this.pointStylePanel.setBorder(new TitledBorder("Point"));
        this.add((Component)this.pointStylePanel, new GridBagConstraints(1, 0, 1, 4, 1.0, 1.0, 12, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void addListeners() {
        this.sizeSpinBox.addActionListener(this);
        this.pointFillColorCombo.addActionListener(this);
        this.pointLineColorCombo.addActionListener(this);
        this.pointStyleCombo.addActionListener(this);
        this.sizeSpinBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SimplePointPropertiesPanel.this._samplePanel.repaint();
            }
        });
        this.checkBoxPanel.addComponentPanel(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.pointLineColorCombo) {
            this.pointLineColorComboChanged();
        } else if (o == this.pointFillColorCombo) {
            this.pointFillColorComboChanged();
        } else if (o == this.pointStyleCombo) {
            this.pointStyleComboChanged();
        } else if (o == this.sizeSpinBox) {
            this.sizeSpinBoxChanged();
        }
    }

    private void pointStyleComboChanged() {
        this._samplePanel.repaint();
    }

    private void sizeSpinBoxChanged() {
        this._samplePanel.repaint();
    }

    public void setSelected(boolean selected) {
        this.checkBoxPanel.setSelected(selected);
    }

    public boolean isSelected() {
        return this.checkBoxPanel.isSelected();
    }

    private void pointFillColorComboChanged() {
        Object[] item = (Object[])this.pointFillColorCombo.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item == this.pFillCustomColor) {
            JDialog dlg = JColorChooser.createDialog(this, "Choose A Color", true, this.getColorChooser(), new pointFillCustomColorOKListener(), null);
            dlg.setVisible(true);
        }
        ((G2dSymbolRenderer)this.pointStyleCombo.getRenderer()).setForegroundColor((Color)item[0]);
        this.pointStyleCombo.repaint();
        this._samplePanel.repaint();
    }

    private void pointLineColorComboChanged() {
        Object[] item = (Object[])this.pointLineColorCombo.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item == this.pLineCustomColor) {
            JDialog dlg = JColorChooser.createDialog(this, "Choose A Color", true, this.getColorChooser(), new pointLineCustomColorOKListener(), null);
            dlg.setVisible(true);
        }
        ((G2dSymbolRenderer)this.pointStyleCombo.getRenderer()).setBackgroundColor((Color)item[0]);
        this.pointStyleCombo.repaint();
        this._samplePanel.repaint();
    }

    @Override
    public void setComponentsEnabled(boolean enabled) {
        this.pointStyleCombo.setEnabled(enabled);
        this.pointFillColorCombo.setEnabled(enabled);
        this.pointLineColorCombo.setEnabled(enabled);
        this.pointStyleLabel.setEnabled(enabled);
        this.pointFillColorLabel.setEnabled(enabled);
        this.pointLineColorLabel.setEnabled(enabled);
        this.pointSizeLabel.setEnabled(enabled);
        this.sizeSpinBox.setEnabled(enabled);
    }

    public int getPointSize() {
        int size = this.sizeSpinBox.getValue();
        return size;
    }

    public void setPointSize(int symbolSize) {
        this.sizeSpinBox.setValue(symbolSize);
    }

    public int getSymbolType() {
        int symbolType = (Integer)this.pointStyleCombo.getSelectedItem();
        return symbolType;
    }

    public Color getPointFillColor() {
        Color pointFColor = (Color)((Object[])this.pointFillColorCombo.getSelectedItem())[0];
        return pointFColor;
    }

    public Color getPointLineColor() {
        Color pointLColor = (Color)((Object[])this.pointLineColorCombo.getSelectedItem())[0];
        return pointLColor;
    }

    public int getPointStyle() {
        return (Integer)this.pointStyleCombo.getSelectedItem();
    }

    public void setPointStyle(int symbolType) {
        this.pointStyleCombo.setSelectedItem(new Integer(symbolType));
    }

    public void setPointLineColor(Color pointLineColor) {
        this.selectColorItem(this.pointLineColorCombo, pointLineColor);
        ((G2dSymbolRenderer)this.pointStyleCombo.getRenderer()).setBackgroundColor(pointLineColor);
    }

    public void setPointFillColor(Color pointFillColor) {
        this.selectColorItem(this.pointFillColorCombo, pointFillColor);
        ((G2dSymbolRenderer)this.pointStyleCombo.getRenderer()).setForegroundColor(pointFillColor);
    }

    public void setCheckBoxVisible(boolean visible) {
        this.checkBoxPanel.setVisible(visible);
    }

    class pointFillCustomColorOKListener
    implements ActionListener {
        pointFillCustomColorOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimplePointPropertiesPanel.this.pFillCustomColor[0] = SimplePointPropertiesPanel.this.getColorChooser().getColor();
            SimplePointPropertiesPanel.this.pointFillColorCombo.repaint();
            SimplePointPropertiesPanel.this.repaint();
        }
    }

    class pointLineCustomColorOKListener
    implements ActionListener {
        pointLineCustomColorOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimplePointPropertiesPanel.this.pLineCustomColor[0] = SimplePointPropertiesPanel.this.getColorChooser().getColor();
            SimplePointPropertiesPanel.this.pointLineColorCombo.repaint();
            SimplePointPropertiesPanel.this.repaint();
        }
    }
}

