/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.components;

import hec.gfx2d.SamplePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJIntegerField;

public class SizePanel
extends JPanel {
    private SamplePanel _samplePanel;
    private RmaJIntegerField _sizeFld;

    public SizePanel(String labelText) {
        this(labelText, 0, 200);
    }

    public SizePanel(String labelText, int min, int max) {
        super(new GridBagLayout());
        this.buildControls(labelText, min, max);
        this.addListeners();
    }

    protected void buildControls(String labelText, int min, int max) {
        JLabel label = new JLabel(labelText);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)label, gbc);
        this._sizeFld = new RmaJIntegerField();
        label.setLabelFor(this._sizeFld);
        this._sizeFld.setMinValue(min);
        this._sizeFld.setMaxValue(max);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._sizeFld, gbc);
    }

    protected void addListeners() {
        DocumentListener dl = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SizePanel.this.updateSamplePanel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SizePanel.this.updateSamplePanel();
            }
        };
    }

    protected void updateSamplePanel() {
        if (this._samplePanel == null) {
            return;
        }
        this._samplePanel.setTextSize(this.getSelectedSize());
    }

    public void setSamplePanel(SamplePanel samplePanel) {
        this._samplePanel = samplePanel;
    }

    public int getSelectedSize() {
        return this._sizeFld.getValueUndefined();
    }

    public void setSelectedSize(int size) {
        this._sizeFld.setValue(size);
    }
}

