/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.components;

import hec.gfx2d.SamplePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextArea;

public class TextPanel
extends EnabledJPanel {
    private JLabel _label;
    private RmaJTextArea _textArea;
    private SamplePanel _samplePanel;

    public TextPanel() {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this._label = new JLabel("Text");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._label, gbc);
        this._textArea = new RmaJTextArea(4, 20);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)new JScrollPane(this._textArea), gbc);
    }

    protected void addListeners() {
        DocumentListener dl = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextPanel.this.updateSamplePanel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextPanel.this.updateSamplePanel();
            }
        };
        this._textArea.getDocument().addDocumentListener(dl);
    }

    protected void updateSamplePanel() {
        if (this._samplePanel == null) {
            return;
        }
        String txt = this.getText();
        this._samplePanel.setSampleText(txt);
        this._samplePanel.repaint();
    }

    public void setText(String text) {
        if (text == null) {
            this._textArea.setText("");
            return;
        }
        this._textArea.setText(text);
    }

    public String getText() {
        return this._textArea.getText();
    }

    public void setSamplePanel(SamplePanel samplePanel) {
        this._samplePanel = samplePanel;
    }
}

