/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.dss;

import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dTimeSeriesLine;
import hec.gfx2d.Viewport;
import hec.gfx2d.dss.LocalDSSTimeSeriesCollection;
import hec.gfx2d.stats.StatisticsGlyph;
import hec.heclib.util.HecTime;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.UnitUtil;
import rma.util.RMAIO;

public class LocalDSSTimeSeriesCollectionGlyph
extends G2dGlyph
implements StatisticsGlyph {
    private final LocalDSSTimeSeriesCollection _obj;
    private boolean _statsShown = true;

    public LocalDSSTimeSeriesCollectionGlyph(Viewport view, LocalDSSTimeSeriesCollection map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
        this._lineArray = new G2dLine[map.getCurveCount() + 4];
        for (int i = 0; i < map.getCurveCount(); ++i) {
            this._lineArray[i] = this._line = new G2dTimeSeriesLine();
            this._line.setScale(scl);
            this._line.setName(this._obj._dssCollectionArray.get(i).getShortName());
            this._line.setGlyph(this);
            ((G2dTimeSeriesLine)this._line).setRawTimeSeriesData(this._obj.tdata, this._obj.ydata[i], (int[])null);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this._obj == null) {
            return;
        }
        for (int i = 0; i < this._obj.getCurveCount(); ++i) {
            G2dLineProperties properties;
            Rectangle rect = this.getVisibleRect();
            if (i == this._obj.getCurveCount() - LocalDSSTimeSeriesCollection.MAX) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.DOT_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else if (i == this._obj.getCurveCount() - LocalDSSTimeSeriesCollection.MIN) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.DOT_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else if (i == this._obj.getCurveCount() - LocalDSSTimeSeriesCollection.MEAN) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.SOLID_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else if (i == this._obj.getCurveCount() - LocalDSSTimeSeriesCollection.SD1P) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.DASH_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else if (i == this._obj.getCurveCount() - LocalDSSTimeSeriesCollection.SD1N) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.DASH_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else {
                this._lineArray[i].setProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
            }
            this._lineArray[i].drawLine(g, rect);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        WorldPt wp;
        double distance;
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (distance = this._line.getNearestLocation(pt, wp = new WorldPt())) != Double.NEGATIVE_INFINITY) {
            HecTime hTime = new HecTime();
            hTime.setMinutes(wp.e);
            this._scale.convertDataTime(hTime);
            String xvalstr = hTime.dateAndTime();
            try {
                double yVal = this._obj.getYParameterId() != -1 && this._obj.getUnitSystem() != 0 && this._scale.getDisplayUnitSystem() != 0 ? UnitUtil.convertUnits((double)wp.n, (int)this._obj.getYParameterId(), (int)this._obj.getUnitSystem(), (int)this._scale.getDisplayUnitSystem()) : wp.n;
                return "<html>" + this._obj.getName() + "<br>[" + xvalstr + ", " + RMAIO.setPrecision2(yVal, 2) + "]</html>";
            }
            catch (DataSetException exp) {
                return "<html>" + this._obj.getName() + "<br>[" + xvalstr + ", " + RMAIO.setPrecision2(wp.n, 2) + "]</html>";
            }
        }
        return null;
    }

    @Override
    public boolean isCurveDrawn(int curveNumber) {
        if (curveNumber < 0 || curveNumber >= this._lineArray.length) {
            return false;
        }
        return this._lineArray[curveNumber] != null;
    }

    @Override
    public void setLineVisible(boolean visible) {
        for (int i = 0; i < this._lineArray.length; ++i) {
            if (this._lineArray[i] == null) continue;
            this._lineArray[i].setVisible(visible);
        }
    }

    @Override
    protected List<ActionListener> getOKListeners() {
        ArrayList<ActionListener> l = new ArrayList<ActionListener>();
        l.add(new PropertiesOKListener());
        return l;
    }

    @Override
    public boolean areStatsDisplayed() {
        return this._statsShown;
    }

    @Override
    public void setStatsDisplayed(boolean displayed) {
        this._statsShown = displayed;
        this.update(this._obj, "update data");
    }

    @Override
    public int getCurveCount() {
        return 1;
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window w = SwingUtilities.windowForComponent(LocalDSSTimeSeriesCollectionGlyph.this.getViewport());
            if (w != null) {
                LocalDSSTimeSeriesCollectionGlyph.this.getViewport().setDirty();
                w.repaint();
            }
            if (LocalDSSTimeSeriesCollectionGlyph.this._viewport != null) {
                if (LocalDSSTimeSeriesCollectionGlyph.this._viewport.getG2dPanel().getLegendPanel() != null) {
                    LocalDSSTimeSeriesCollectionGlyph.this._viewport.getG2dPanel().getLegendPanel().refreshLegendItems();
                }
                LocalDSSTimeSeriesCollectionGlyph.this._viewport.getG2dPanel().repaint();
            }
        }
    }
}

