/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.histogram;

import hec.gfx2d.histogram.BinOrigin;

public class HistogramBin {
    private double _min;
    private double _max;
    private double _frequency;

    HistogramBin(double min, double max, double frequency) {
        this._frequency = frequency;
        this._min = min;
        this._max = max;
    }

    HistogramBin(double width, double index, double frequency, BinOrigin origin) {
        double max;
        double min;
        this._frequency = frequency;
        switch (origin) {
            case LEFT: {
                min = index;
                max = index + width;
                break;
            }
            case CENTER: {
                min = index - width / 2.0;
                max = index + width / 2.0;
                break;
            }
            case RIGHT: {
                min = index - width;
                max = index;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to determine min and max given an origin of " + origin);
            }
        }
        this._min = min;
        this._max = max;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getFrequency() {
        return this._frequency;
    }
}

