/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.histogram;

import hec.geometry.Axis;
import hec.geometry.Scale;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.Viewport;
import hec.gfx2d.histogram.HistogramBin;
import hec.gfx2d.histogram.HistogramDataSet;
import hec.gfx2d.histogram.HistogramDataSetImpl;
import hec.gfx2d.histogram.PairedDataHistogramDataSet;
import hec.gfx2d.swing.charts.bar.BarGlyph;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.List;

public class HistogramDataGlyph
extends BarGlyph {
    public static final double ROTATE_LABEL_ANGLE = Math.toRadians(-60.0);

    public HistogramDataGlyph(Viewport view, PairedDataHistogramDataSet map, Scale scl) {
        super(view, map, scl);
    }

    public HistogramDataGlyph(Viewport view, HistogramDataSetImpl map, Scale scl) {
        super(view, map, scl);
    }

    @Override
    public void draw(Graphics g) {
        G2dObject obj = this.getG2dObject();
        if (obj instanceof HistogramDataSet) {
            HistogramDataSet data = (HistogramDataSet)obj;
            List<HistogramBin> bins = data.getHistogramBins();
            for (HistogramBin bin : bins) {
                List lineProperties;
                Rectangle2D.Float rect = this.generateRectangle(bin);
                G2dGlyphDrawProp props = this.getProperties();
                if (props == null || (lineProperties = props.lineProperties) == null || lineProperties.isEmpty()) continue;
                G2dLineProperties lineProps = (G2dLineProperties)lineProperties.get(0);
                this.drawRectWithProperties(g, rect, lineProps, bin.getFrequency());
            }
        }
    }

    @Override
    protected boolean showLabel() {
        return false;
    }

    @Override
    protected NumberFormat getValueFormatter() {
        return null;
    }

    private Rectangle2D.Float generateRectangle(HistogramBin bin) {
        Scale scale = this.getScale();
        Axis axis = scale.getAxis(1);
        double min = bin.getMin();
        double max = bin.getMax();
        double freq = bin.getFrequency();
        double minY = Math.min(freq, axis.getMin());
        int zeroY = scale.n2y(minY);
        int freqY = scale.n2y(freq);
        int x = scale.e2x(min);
        int width = scale.e2x(max) - x;
        int y = Math.min(zeroY, freqY);
        int y2 = Math.max(zeroY, freqY);
        int height = y2 - y;
        return new Rectangle2D.Float(x, y, width, height);
    }
}

