/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.histogram;

import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.histogram.HistogramBin;
import hec.gfx2d.histogram.HistogramDataGlyph;
import hec.gfx2d.histogram.HistogramDataProvider;
import hec.gfx2d.histogram.HistogramDataSet;
import java.util.List;
import java.util.Objects;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HistogramDataSetImpl
extends G2dData
implements HistogramDataSet {
    ChangeListener _changeListener;
    private HistogramDataProvider _provider;
    private String _xAxisName;
    private String _yAxisName;

    public HistogramDataSetImpl(HistogramDataProvider provider) {
        this._provider = provider;
        this._xAxisName = "";
        this._yAxisName = "";
        this._changeListener = new ChangeListenerImpl();
        this._provider.addChangeListener(this._changeListener);
    }

    @Override
    public WorldRect getBounds() {
        List<HistogramBin> histogramBins = this._provider.getHistogramBins();
        double minx = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        double miny = Double.MAX_VALUE;
        for (HistogramBin histogramBin : histogramBins) {
            minx = Math.min(minx, histogramBin.getMin());
            maxx = Math.max(maxx, histogramBin.getMax());
            maxy = Math.max(maxy, histogramBin.getFrequency());
            miny = Math.min(miny, histogramBin.getFrequency());
        }
        WorldRect r = new WorldRect(minx, maxy, maxx, miny);
        return r;
    }

    public void setHistogramDataProvider(HistogramDataProvider provider) {
        Objects.requireNonNull(this.name, "HistogramDataProvider cannot be null");
        this._provider = provider;
        this.setChanged();
        this.notifyObservers("reset data");
    }

    @Override
    public String getXAxisName() {
        return this._xAxisName;
    }

    @Override
    public String getYAxisName() {
        return this._yAxisName;
    }

    public void setYAxisName(String name) {
        Objects.requireNonNull(name, "YAxis name cannot be null");
        this._yAxisName = name;
    }

    public void setXAxisName(String name) {
        Objects.requireNonNull(name, "XAxis name cannot be null");
        this._xAxisName = name;
    }

    @Override
    public int getXAxisType() {
        return 0;
    }

    @Override
    public int getYAxisType() {
        return 0;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public List<HistogramBin> getHistogramBins() {
        return this._provider.getHistogramBins();
    }

    static {
        G2dGlyphFactory.addMapping(HistogramDataSetImpl.class.getName(), HistogramDataGlyph.class.getName());
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            HistogramDataSetImpl.this.setChanged();
            HistogramDataSetImpl.this.notifyObservers("reset data");
        }
    }
}

