/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.histogram;

import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.histogram.BinOrigin;
import hec.gfx2d.histogram.HistogramBin;
import hec.gfx2d.histogram.HistogramDataGlyph;
import hec.gfx2d.histogram.HistogramDataSet;
import hec.io.PairedDataContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PairedDataHistogramDataSet
extends PairedDataSet
implements HistogramDataSet {
    private final List<HistogramBin> _bins = new ArrayList<HistogramBin>();

    public PairedDataHistogramDataSet(PairedDataContainer pdc, double binWidth, BinOrigin binOrigin) {
        super(pdc);
        if (this.getCurveCount() > 2) {
            throw new IllegalArgumentException("Paired data histogram data sets only support up to two curves.");
        }
        this.loadBinData(binOrigin, binWidth);
    }

    private void loadBinData(BinOrigin binOrigin, double fixedBinWidth) {
        double[] xValues = this.xdata;
        double[] yValues = this.ydata[0];
        double[] widths = new double[yValues.length];
        if (this.ydata.length == 2) {
            widths = this.ydata[1];
        } else {
            Arrays.fill(widths, fixedBinWidth);
        }
        for (int i = 0; i < xValues.length; ++i) {
            double xValue = xValues[i];
            double yValue = yValues[i];
            double binWidth = widths[i];
            HistogramBin bin = new HistogramBin(binWidth, xValue, yValue, binOrigin);
            this._bins.add(bin);
        }
    }

    @Override
    protected void buildBounds(int xDivisor, int yDivisor) {
        super.buildBounds(xDivisor, yDivisor);
        if (!this._bins.isEmpty()) {
            HistogramBin leftBin = this._bins.get(0);
            this.bounds.w = leftBin.getMin();
            HistogramBin rightBin = this._bins.get(this._bins.size() - 1);
            this.bounds.e = rightBin.getMax();
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (HistogramBin bin : this._bins) {
                double freq = bin.getFrequency();
                min = Math.min(freq, min);
                max = Math.max(freq, max);
            }
            this.bounds.n = max;
            this.bounds.s = min;
        }
    }

    @Override
    public List<HistogramBin> getHistogramBins() {
        return new ArrayList<HistogramBin>(this._bins);
    }

    static {
        G2dGlyphFactory.addMapping(PairedDataHistogramDataSet.class, HistogramDataGlyph.class);
    }
}

