/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.histogram;

import hec.gfx2d.histogram.BinOrigin;
import hec.gfx2d.histogram.HistogramBin;
import hec.gfx2d.histogram.HistogramDataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleHistogramDataProvider
implements HistogramDataProvider {
    List<HistogramBin> _histogramBins;
    List<ChangeListener> _listeners = new ArrayList<ChangeListener>();

    public SimpleHistogramDataProvider(double[] index, double[] binWidth, double[] frequency, BinOrigin origin) {
        this._histogramBins = new ArrayList<HistogramBin>();
        this.setHistogramDataPrivate(index, binWidth, frequency, origin);
    }

    public SimpleHistogramDataProvider(double[] min, double[] max, double[] frequency) {
        this._histogramBins = new ArrayList<HistogramBin>();
        this.setHistogramDataPrivate(min, max, frequency);
    }

    private void setHistogramDataPrivate(double[] index, double[] binWidth, double[] frequency, BinOrigin origin) {
        this._histogramBins.clear();
        for (int i = 0; i < index.length; ++i) {
            this._histogramBins.add(new HistogramBin(binWidth[i], index[i], frequency[i], origin));
        }
    }

    private void setHistogramDataPrivate(double[] min, double[] max, double[] frequency) {
        this._histogramBins.clear();
        for (int i = 0; i < min.length; ++i) {
            this._histogramBins.add(new HistogramBin(min[i], max[i], frequency[i]));
        }
    }

    public void setHistogramData(double[] index, double[] binWidth, double[] frequency, BinOrigin origin) {
        this.setHistogramDataPrivate(index, binWidth, frequency, origin);
        this.fireChangeEvent();
    }

    @Override
    public List<HistogramBin> getHistogramBins() {
        return this._histogramBins;
    }

    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        this._listeners.stream().filter(l -> l != null).forEach(l -> l.stateChanged(e));
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this._listeners.remove(listener);
    }
}

