/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.paint;

import hec.geometry.IScale;
import hec.gfx2d.G2dPaint;
import hec.gfx2d.paint.G2dGradientPaintContext;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.Collections;
import java.util.Map;

public class G2dGradientPaint
implements G2dPaint {
    private final Color minValueColor;
    private final Color maxValueColor;
    Map<String, Object> currentDrawParameters = Collections.EMPTY_MAP;

    public G2dGradientPaint(Color maxValueColor, Color minValueColor) {
        this.maxValueColor = maxValueColor;
        this.minValueColor = minValueColor;
    }

    @Override
    public void setPaintParameters(Map<String, Object> parameters) {
        this.currentDrawParameters = parameters != null ? parameters : Collections.EMPTY_MAP;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        IScale at = (IScale)this.currentDrawParameters.get("SCALE");
        Rectangle2D worldBounds = (Rectangle2D)this.currentDrawParameters.get("WORLD_BOUNDS");
        return new G2dGradientPaintContext(worldBounds, at, this.minValueColor, this.maxValueColor);
    }

    @Override
    public int getTransparency() {
        return 1;
    }
}

