/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.paint;

import hec.geometry.IScale;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import rma.lang.RmaMath;

public class G2dGradientPaintContext
implements PaintContext {
    private final Rectangle2D _worldBounds;
    private final Color _minColor;
    private final Color _maxColor;
    private final IScale _scale;
    float[] colorComp = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    WritableRaster tileRaster = null;

    public G2dGradientPaintContext(Rectangle2D worldBounds, IScale localToWorldScale, Color minColor, Color maxColor) {
        this._scale = localToWorldScale;
        this._worldBounds = worldBounds;
        this._minColor = minColor;
        this._maxColor = maxColor;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        if (this.tileRaster == null || this.tileRaster.getWidth() < w || this.tileRaster.getHeight() < h) {
            this.tileRaster = this.getColorModel().createCompatibleWritableRaster(w, h);
        }
        Point2D.Double srcPt = new Point2D.Double();
        Point2D.Double dstPt = new Point2D.Double();
        double maxY = this._worldBounds.getY() + this._worldBounds.getHeight();
        double minY = this._worldBounds.getY();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int yloc = j + y;
                double y2n = this._scale.y2n(yloc);
                this.colorComp[0] = (float)RmaMath.linearInterpolate(minY, this._minColor.getRed(), maxY, this._maxColor.getRed(), y2n);
                this.colorComp[1] = (float)RmaMath.linearInterpolate(minY, this._minColor.getGreen(), maxY, this._maxColor.getGreen(), y2n);
                this.colorComp[2] = (float)RmaMath.linearInterpolate(minY, this._minColor.getBlue(), maxY, this._maxColor.getBlue(), y2n);
                this.colorComp[3] = (float)RmaMath.linearInterpolate(minY, this._minColor.getAlpha(), maxY, this._maxColor.getAlpha(), y2n);
                this.tileRaster.setPixel(i, j, this.colorComp);
            }
        }
        return this.tileRaster;
    }
}

