/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.paint;

import hec.gfx2d.paint.PaintWriter;
import java.awt.GradientPaint;
import java.awt.geom.Point2D;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import rma.swing.RmaColor;

public class GradientPaintWriter
implements PaintWriter<GradientPaint> {
    @Override
    public Map<String, String> writePaint(GradientPaint p) {
        TreeMap<String, String> parameters = new TreeMap<String, String>(new KeySorter());
        parameters.put(Keys.name.toString(), "GradientPaint");
        parameters.put(Keys.color1.toString(), RmaColor.getRGBString(p.getColor1()));
        parameters.put(Keys.point1.toString(), this.pointToString(p.getPoint1()));
        parameters.put(Keys.color2.toString(), RmaColor.getRGBString(p.getColor2()));
        parameters.put(Keys.point2.toString(), this.pointToString(p.getPoint2()));
        parameters.put(Keys.cyclic.toString(), Boolean.toString(p.isCyclic()));
        return parameters;
    }

    private String pointToString(Point2D point) {
        return point.getX() + "," + point.getY();
    }

    public static void main(String[] args) {
    }

    private static class KeySorter
    implements Comparator<String> {
        private KeySorter() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            Keys[] values = Keys.values();
            boolean foundO2 = false;
            for (Keys value : values) {
                String keyStr = value.toString();
                if (keyStr.equals(o2)) {
                    foundO2 = true;
                    break;
                }
                if (!keyStr.equals(o1)) continue;
                foundO2 = false;
                break;
            }
            if (!foundO2) {
                return -1;
            }
            return 1;
        }
    }

    static enum Keys {
        name,
        color1,
        point1,
        color2,
        point2,
        cyclic;

    }
}

