/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.profilePlot;

import hec.dataTable.HecDataTableFrame;
import hec.geometry.Axis;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.Viewport;
import hec.gfx2d.profilePlot.ProfileAnimationDlg;
import hec.gfx2d.profilePlot.ProfileDataG2dGlyph;
import hec.gfx2d.profilePlot.ProfileDataG2dObject;
import hec.heclib.util.HecTime;
import hec.io.PairedDataContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import rma.services.ServiceLookup;
import rma.swing.VCRControlsListener;
import rma.util.VCRPlayer;

public class AnimatedProfileG2dDialog
extends G2dDialog
implements VCRControlsListener {
    protected List _plotObjs;
    boolean _reverseX = false;
    boolean _reverseY = false;
    String parameter = "PH";
    JMenuItem _jmi_Animate;
    Frame _parent;
    Vector _colorVec;
    String _title;
    String _plotTitle;
    List _timeList;
    int _currentPos;
    public static final int MAX_PAIRED_DATA_POINTS = 500;
    public static HelpBroker _helpBroker;
    public static HelpSet _helpSet;
    private HecTime _startTime = new HecTime();
    private HecTime _endTime = new HecTime();
    private HecTime _currentTime = new HecTime();
    MessageFormat titleText = new MessageFormat("{0}");
    ProfileAnimationDlg dlg;
    JMenu _parameterMenu;

    public AnimatedProfileG2dDialog(Frame owner, String title, boolean modal, Vector datavec, Vector colorvec, boolean reverseX, boolean reverseY) {
        super(owner, title, modal, datavec, colorvec);
        this._plotObjs = datavec;
        this._colorVec = colorvec;
        this._parent = owner;
        this._title = title;
        this._reverseX = reverseX;
        this._reverseY = reverseY;
        JMenuBar menubar = this.getJMenuBar();
        int menucnt = menubar.getMenuCount();
        JMenu viewmenu = null;
        if (menucnt >= 2) {
            viewmenu = menubar.getMenu(menucnt - 1);
            viewmenu.addSeparator();
        } else {
            viewmenu = new JMenu("View");
            viewmenu.setMnemonic('V');
            menubar.add(viewmenu);
        }
        this.configureData();
        this._jmi_Animate = new JMenuItem("Animate", 65);
        viewmenu.add(this._jmi_Animate);
        this._jmi_Animate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimatedProfileG2dDialog.this.animatePlot();
            }
        });
        this.jConfigurePlotLayout.setVisible(false);
        boolean hasTitle = false;
        ArrayList parameterList = new ArrayList();
        for (int i = 0; i < this._plotObjs.size(); ++i) {
            Object obj = this._plotObjs.get(i);
            if (obj instanceof ProfileDataG2dObject && !hasTitle) {
                String sTime = this._startTime.dateAndTime(107);
                super.setTitle(sTime);
            }
            if (!(obj instanceof ProfileDataG2dObject)) continue;
            List list = ((ProfileDataG2dObject)obj).getParameterNames();
            int possition = ((ProfileDataG2dObject)obj)._rec.getTimeStepPosition(this._startTime.value());
            HecTime time = ((ProfileDataG2dObject)obj)._rec.getStartTime();
            String time2 = time.date();
            ((ProfileDataG2dObject)obj).getYData(possition, list.get(0).toString());
            ((ProfileDataG2dObject)obj).getXData(possition);
            if (parameterList.isEmpty()) {
                parameterList.addAll(list);
                continue;
            }
            for (int ls = 0; ls < list.size(); ++ls) {
                if (parameterList.contains(list.get(ls))) continue;
                parameterList.add(list.get(ls));
            }
        }
        this._parameterMenu = new JMenu();
        if (parameterList.size() > 0) {
            this._parameterMenu = new JMenu("Parameter");
            this._parameterMenu.setMnemonic('m');
            menubar.add(this._parameterMenu);
        }
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < parameterList.size(); ++i) {
            ParameterMenuItem action = new ParameterMenuItem(parameterList.get(i).toString());
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(action);
            if (i == 0) {
                menuItem.setSelected(true);
                this.parameter = parameterList.get(0).toString();
            }
            bg.add(menuItem);
            this._parameterMenu.add(menuItem);
        }
        this._gfxPanel.getViewports()[0].getAxis("X1").setReversed(this._reverseX);
        this._gfxPanel.getViewports()[0].getAxis("Y1").setReversed(this._reverseY);
        Axis obj = this._gfxPanel.getViewports()[0].getAxis("Y1");
        Vector vplist = this.getViewports();
    }

    private void configureData() {
        ProfileDataG2dObject proOb = null;
        for (int i = 0; i < this._plotObjs.size(); ++i) {
            if (!(this._plotObjs.get(i) instanceof ProfileDataG2dObject)) continue;
            proOb = (ProfileDataG2dObject)this._plotObjs.get(i);
            if (!this._startTime.isDefined()) {
                this._startTime.set(proOb._rec.getStartTime());
                this._endTime.set(proOb._rec.getEndTime());
                continue;
            }
            if (proOb._rec.getStartTime().value() > this._startTime.value()) {
                this._startTime.set(proOb._rec.getStartTime());
            }
            if (proOb._rec.getEndTime().value() >= this._endTime.value()) continue;
            this._endTime.set(proOb._rec.getEndTime());
        }
        this._timeList = proOb.getTimeList();
        this._currentTime = new HecTime(this._startTime);
    }

    public void setParameterDisplayed(String param) {
        this.parameter = param;
        Component[] comps = this._parameterMenu.getMenuComponents();
        for (int i = 0; i < comps.length; ++i) {
            JCheckBoxMenuItem menuPop;
            if (!(comps[i] instanceof JCheckBoxMenuItem) || !(menuPop = (JCheckBoxMenuItem)comps[i]).getText().equals(this.parameter)) continue;
            menuPop.doClick();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem c2 = (JMenuItem)e.getSource();
            String arg = c2.getText();
            if (arg.equals("Tabulate")) {
                this.tabulate(true);
                return;
            }
            super.actionPerformed(e);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public HecDataTableFrame tabulate(boolean showTable) {
        Vector tempG2dObjects = this._gfxPanel.getPlotObjects();
        Vector g2dObjects = null;
        if (tempG2dObjects != null && tempG2dObjects.size() > 0) {
            g2dObjects = (Vector)tempG2dObjects.clone();
        }
        if ((g2dObjects = this.getTabulateObjects(g2dObjects)).isEmpty()) {
            return null;
        }
        int status = -1;
        HecDataTableFrame table = new HecDataTableFrame((Object)this);
        status = table.setData(g2dObjects);
        System.out.println("Tabulate Status = " + status);
        if (status == 0) {
            table.allowEditing(false);
            if (showTable) {
                table.show();
            }
        }
        return table;
    }

    protected Vector getTabulateObjects(Vector v) {
        Vector<Object> returnVec = new Vector<Object>(v.size());
        G2dObject firstObj = (G2dObject)v.get(0);
        Class<?> c2 = firstObj.getClass();
        for (int i = 0; i < v.size(); ++i) {
            Object obj = this.getTabulateObject(v.get(i), c2);
            if (obj == null) continue;
            returnVec.add(obj);
        }
        return returnVec;
    }

    @Override
    public Object getTabulateObject(Object obj, Class firstObjClass) {
        if (obj instanceof ProfileDataG2dObject) {
            ProfileDataG2dObject proObj = (ProfileDataG2dObject)obj;
            PairedDataContainer pdContainer = new PairedDataContainer();
            double[] xval = new double[proObj._profx.length];
            double[] yval = new double[proObj._profx.length];
            for (int i = 0; i < proObj._profx.length; ++i) {
                xval[i] = proObj._profx[i];
                yval[i] = proObj._profy[i];
            }
            pdContainer.xOrdinates = xval;
            pdContainer.yOrdinates = new double[1][proObj._profx.length];
            pdContainer.yOrdinates[0] = yval;
            pdContainer.numberOrdinates = proObj._profx.length;
            pdContainer.yparameter = this.parameter + "-\n" + proObj.getName();
            pdContainer.xparameter = "Elevation";
            pdContainer.numberCurves = 1;
            PairedDataSet set = new PairedDataSet(pdContainer);
            return set;
        }
        return super.getTabulateObject(obj, firstObjClass);
    }

    public void animatePlot() {
        if (this.dlg == null) {
            this.dlg = new ProfileAnimationDlg(this, "Animation Control", false, new VCR());
            int numTimeSteps = 0;
            for (int i = 0; i < this._plotObjs.size(); ++i) {
                Object obj = this._plotObjs.get(i);
                if (!(obj instanceof ProfileDataG2dObject)) continue;
                ProfileDataG2dObject proOb = (ProfileDataG2dObject)obj;
                this._timeList.clear();
                this._timeList = proOb.getTimeList();
                numTimeSteps = this._timeList.size();
                this.dlg.setMaxValue(numTimeSteps - 1);
            }
            this.dlg.setCurrentPosition(0);
        }
        this.dlg.setLocationRelativeTo(this);
        this.dlg.setVisible(true);
    }

    @Override
    public void controlSelected(int cmd) {
    }

    @Override
    public void sliderMoved(int pos) {
        if (this._plotObjs == null || pos < 0) {
            return;
        }
        for (int i = 0; i < this._plotObjs.size(); ++i) {
            Object obj = this._plotObjs.get(i);
            if (!(obj instanceof ProfileDataG2dObject)) continue;
            ProfileDataG2dObject po = (ProfileDataG2dObject)obj;
            int possition = po._rec.getTimeStepPosition((Integer)this._timeList.get(pos));
            if (possition < 0) {
                return;
            }
            po.getYData(possition, this.parameter);
            po.getXData(possition);
            this._currentTime = new HecTime((Integer)this._timeList.get(pos), 1);
        }
        this._currentPos = pos;
    }

    public void setAnimationTitle(String plotTitle) {
        this._plotTitle = plotTitle;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    static {
        G2dGlyphFactory.addMapping(ProfileDataG2dObject.class.getName(), ProfileDataG2dGlyph.class.getName());
    }

    private class ParameterMenuItem
    extends AbstractAction {
        public ParameterMenuItem(String name) {
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            boolean setScatterVisable = false;
            double min = 0.0;
            double max = 0.0;
            AnimatedProfileG2dDialog.this.parameter = this.getValue("Name").toString();
            if (AnimatedProfileG2dDialog.this._plotObjs == null) {
                return;
            }
            for (i = 0; i < AnimatedProfileG2dDialog.this._plotObjs.size(); ++i) {
                Object obj = AnimatedProfileG2dDialog.this._plotObjs.get(i);
                if (!(obj instanceof ProfileDataG2dObject)) continue;
                ProfileDataG2dObject po = (ProfileDataG2dObject)obj;
                po.getYData(0, AnimatedProfileG2dDialog.this.parameter);
            }
            AnimatedProfileG2dDialog.this._gfxPanel.setVisible(false);
            AnimatedProfileG2dDialog.this._gfxPanel.clearPanel();
            if (Boolean.getBoolean("ReportStylePlots") && AnimatedProfileG2dDialog.this._plotObjs.size() <= 2) {
                for (i = 0; i < AnimatedProfileG2dDialog.this._plotObjs.size(); ++i) {
                    if (!(AnimatedProfileG2dDialog.this._plotObjs.get(i) instanceof ProfileDataG2dObject) || AnimatedProfileG2dDialog.this._plotObjs.size() >= 2) continue;
                    ProfileDataG2dObject po = (ProfileDataG2dObject)AnimatedProfileG2dDialog.this._plotObjs.get(i);
                    AnimatedProfileG2dDialog.this.setTitle("Title");
                    po.setName("Computed");
                }
            }
            AnimatedProfileG2dDialog.this._gfxPanel.buildComponents(AnimatedProfileG2dDialog.this._plotObjs);
            AnimatedProfileG2dDialog.this._gfxPanel.useLineStyles(true);
            if (Boolean.getBoolean("ReportStylePlots")) {
                AnimatedProfileG2dDialog.this._gfxPanel.getLegendPanel().setVisible(false);
                Viewport[] viewports = AnimatedProfileG2dDialog.this._gfxPanel.getViewports();
                viewports[0].getProperties().drawViewportLegend = true;
                Vector v = AnimatedProfileG2dDialog.this._gfxPanel.getLinePropertyObjects();
                G2dLineProperties lineProp = (G2dLineProperties)v.get(1);
                lineProp.setDrawLine(false);
                lineProp.setDrawPoints(true);
                lineProp.setSymbolSize(2.0f);
                lineProp.setSymbolType(4);
                lineProp.setSymbolFillColor(Color.RED);
                lineProp.setSymbolLineColor(Color.RED);
                Viewport[] viewportArray = AnimatedProfileG2dDialog.this._gfxPanel.getViewports();
            }
            ServiceLookup.getUnitsDisplayService().updateUnitSystem(AnimatedProfileG2dDialog.this._gfxPanel);
            if (max > 0.0) {
                AnimatedProfileG2dDialog.this._gfxPanel.getViewports()[0].getAxis("Y1").setMinMax(min, max);
            }
            AnimatedProfileG2dDialog.this._gfxPanel.getViewports()[0].updateUI();
            AnimatedProfileG2dDialog.this._gfxPanel.getViewports()[0].getAxis("X1").setReversed(AnimatedProfileG2dDialog.this._reverseX);
            AnimatedProfileG2dDialog.this._gfxPanel.getViewports()[0].getAxis("Y1").setReversed(AnimatedProfileG2dDialog.this._reverseY);
            AnimatedProfileG2dDialog.this.sliderMoved(AnimatedProfileG2dDialog.this._currentPos);
            AnimatedProfileG2dDialog.this._gfxPanel.setVisible(true);
        }
    }

    private class VCR
    implements VCRPlayer {
        int step = 0;
        int delay = 50;
        int size = 0;
        boolean paused = false;

        public VCR() {
            for (int i = 0; i < AnimatedProfileG2dDialog.this._plotObjs.size(); ++i) {
                int temp;
                Object obj = AnimatedProfileG2dDialog.this._plotObjs.get(i);
                if (!(obj instanceof ProfileDataG2dObject) || (temp = ((ProfileDataG2dObject)obj).getRecordCount()) <= this.size) continue;
                this.size = temp - 1;
            }
        }

        @Override
        public void setCurrentPosition(int pos) {
            this.step = pos;
            AnimatedProfileG2dDialog.this.sliderMoved(pos);
        }

        @Override
        public void setPaused(boolean p) {
            this.paused = p;
        }

        @Override
        public void setDelay(int delay) {
            this.delay = delay;
        }

        @Override
        public int getCurrentPosition() {
            return this.step;
        }

        @Override
        public int getDelay() {
            return this.delay;
        }

        @Override
        public int getPlaySize() {
            return this.size;
        }

        @Override
        public String getCurrentLocation() {
            for (int i = 0; i < AnimatedProfileG2dDialog.this._plotObjs.size(); ++i) {
                Object obj = AnimatedProfileG2dDialog.this._plotObjs.get(i);
                if (!(obj instanceof ProfileDataG2dObject)) continue;
                String timeStep = "";
                if (AnimatedProfileG2dDialog.this._currentTime != null) {
                    timeStep = AnimatedProfileG2dDialog.this._currentTime.dateAndTime();
                }
                AnimatedProfileG2dDialog.this.dlg.setCurrentLocation(timeStep);
                ProfileDataG2dObject pobj = (ProfileDataG2dObject)obj;
                Object ptitle = "";
                if (AnimatedProfileG2dDialog.this._plotTitle != null && AnimatedProfileG2dDialog.this._plotTitle.length() > 0) {
                    ptitle = AnimatedProfileG2dDialog.this._plotTitle + " - ";
                }
                ptitle = (String)ptitle + AnimatedProfileG2dDialog.this.titleText.format(new Object[]{timeStep});
                AnimatedProfileG2dDialog.this.setTitle(AnimatedProfileG2dDialog.this.titleText.format(new Object[]{timeStep}));
                AnimatedProfileG2dDialog.this.getPlotTitle().setText((String)ptitle);
                AnimatedProfileG2dDialog.this.repaint();
                return timeStep;
            }
            return "";
        }

        @Override
        public void play(int startPosition) {
            System.out.println("PLAY - " + this.delay);
        }

        @Override
        public void fastForward(int startPosition) {
            System.out.println("FF - " + this.delay);
        }

        @Override
        public void stop() {
        }

        @Override
        public boolean hasData() {
            return true;
        }
    }
}

