/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.profilePlot;

import hec.gfx2d.profilePlot.AnimatedProfileG2dDialog;
import hec.gfx2d.profilePlot.VCRControlEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaVcrControls;
import rma.util.VCRControlsListenerImpl;
import rma.util.VCRPlayer;

public class ProfileAnimationDlg
extends RmaJDialog {
    AnimatedProfileG2dDialog _parent;
    RmaVcrControls _vcr;
    VCRPlayer _vcrplayer;
    VCRControlsListenerImpl _listener;
    private int _speed = 50;
    private JMenu _viewMenu;
    private JMenuItem _speedMenuItem;

    public ProfileAnimationDlg(AnimatedProfileG2dDialog owner, String title, boolean modal, VCRPlayer player) {
        super(owner, title, modal);
        this._parent = owner;
        this._vcrplayer = player;
        this.buildComponents();
    }

    public void setCurrentLocation(String loc) {
        this._vcr.setCurrentLocation(loc);
    }

    public void setCurrentPosition(int pos) {
        this._vcr.setCurrentPosition(pos);
    }

    public void setMaxValue(int max) {
        this._vcr.setMaxValue(max);
    }

    public void setStartLabel(String startText) {
        this._vcr.setStartLabel(startText);
    }

    private void setSpeed() {
        RmaJDialog controls = new RmaJDialog();
    }

    public void setSpeed(int speed) {
        this._speed = speed;
        this._listener.setPlayDelay(this._speed);
        this._listener.setFastForwardDelay(this._speed / 2);
    }

    public void setEndLabel(String endText) {
        this._vcr.setEndLabel(endText);
    }

    void buildComponents() {
        this.setSize(250, 100);
        this.getContentPane().setLayout(new BorderLayout());
        this._vcr = new RmaVcrControls();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        gbc.anchor = 10;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._vcr, gbc);
        this._vcr.addVCRControlsListener(this._parent);
        this._listener = new VCRControlsListenerImpl(this._vcr, this._vcrplayer){

            @Override
            public void sliderMoved(int pos) {
                if (this._player == null) {
                    return;
                }
                this._player.setCurrentPosition(pos);
                if (this._displayCurrentLoc) {
                    String curLoc = this._player.getCurrentLocation();
                    this._controls.setCurrentLocation(curLoc);
                    this._controls.setNoData(!this._player.hasData());
                }
            }
        };
        JMenuBar menubar = new JMenuBar();
        this._viewMenu = new JMenu("Options");
        this._viewMenu.setMnemonic('O');
        menubar.add(this._viewMenu);
        this.setJMenuBar(menubar);
        this._speedMenuItem = new JMenuItem("Play Delay", 80);
        this._viewMenu.add(this._speedMenuItem);
        this._speedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileAnimationDlg.this.changeSpeed();
            }
        });
        this._listener.setPlayDelay(this._speed);
        this._listener.setFastForwardDelay(this._speed / 2);
        this._vcr.addVCRControlsListener(this._listener);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
    }

    private void changeSpeed() {
        VCRControlEditor editor = new VCRControlEditor(this, this._speed);
        editor.setLocationRelativeTo(this);
        editor.setVisible(true);
    }

    public void ProfileAnimationDlg_WindowClosing(WindowEvent event) {
        this._listener.controlSelected(3);
        this.dispose();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ProfileAnimationDlg.this) {
                ProfileAnimationDlg.this.ProfileAnimationDlg_WindowClosing(event);
            }
        }
    }
}

