/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.profilePlot;

import hec.geometry.Scale;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.Viewport;
import hec.gfx2d.profilePlot.ProfileDataG2dObject;
import java.awt.Graphics;
import java.awt.Rectangle;
import rma.util.RMAConst;

public class ProfileDataG2dGlyph
extends G2dGlyph {
    ProfileDataG2dObject _obj;

    public ProfileDataG2dGlyph(Viewport view, ProfileDataG2dObject map, Scale scl) {
        super(view, map, scl);
        this._obj = map;
    }

    @Override
    public void draw(Graphics g) {
        int i;
        if (this._obj == null) {
            return;
        }
        float[] horizArray = this._obj.getHorizArray();
        float[] vertArray = this._obj.getVertArray();
        if (horizArray == null || vertArray == null) {
            return;
        }
        double[] xarray = new double[horizArray.length];
        double[] yarray = new double[vertArray.length];
        Rectangle rect = this.getVisibleRect();
        this._line.clearLineData();
        int ilen = this._obj._profx.length;
        boolean firstpass = true;
        int validPoints = 0;
        for (int ioff = 0; ioff < ilen; ioff += i) {
            int imax;
            if (!firstpass && ioff > 0) {
                --ioff;
            }
            if ((imax = 10000) > ilen - ioff) {
                imax = ilen - ioff;
            }
            for (i = 0; i < imax; ++i) {
                double dx = horizArray[i + ioff];
                double dy = vertArray[i + ioff];
                if (!RMAConst.isValidValue(dx) || !RMAConst.isValidValue(dy)) {
                    ++i;
                    break;
                }
                xarray[i] = dx;
                yarray[i] = dy;
                ++validPoints;
            }
            this._line.addLineSegment(xarray, yarray, validPoints);
            validPoints = 0;
            if (i != imax || !firstpass) continue;
            firstpass = false;
        }
        this._line.drawLine(g, rect);
    }
}

