/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.profilePlot;

import hec.data.Parameter;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.profilePlot.ProfileDataG2dGlyph;
import hec.gfx2d.profilePlot.ProfileDataRecords;
import java.util.List;
import rma.util.RMAConst;

public class ProfileDataG2dObject
extends G2dData {
    protected ProfileDataRecords _rec;
    protected float[] _profx;
    protected float[] _profy;
    protected WorldRect _bounds;
    protected String _parameter = "";
    protected String _runName = "";
    protected String _name;

    public ProfileDataG2dObject(ProfileDataRecords rec, String runName) {
        this(rec, runName, 0);
    }

    public ProfileDataG2dObject(ProfileDataRecords rec, String runName, int timeStepStart) {
        this._rec = rec;
        this._runName = runName;
        this.getXData(timeStepStart);
    }

    public List getParameterNames() {
        return this._rec.getParameterNames();
    }

    public List<Integer> getTimeList() {
        return this._rec.getTimeList();
    }

    public int getRecordCount() {
        return this._rec.getRecordCount();
    }

    public float[] getHorizArray() {
        if (this._rec.getType() == 1) {
            return this._profy;
        }
        return this._profx;
    }

    public float[] getVertArray() {
        if (this._rec.getType() == 1) {
            return this._profx;
        }
        return this._profy;
    }

    public void getYData(int istep, String parameter) {
        this._profy = this._rec.getYData(istep, parameter);
        this.setChanged();
        if (parameter.equals(this._parameter)) {
            this.notifyObservers("update data");
        } else {
            this._bounds = null;
            this._parameter = parameter;
            this.notifyObservers("reset data");
        }
    }

    public void getXData(int istep) {
        this._profx = this._rec.getXData(istep);
        this.setChanged();
    }

    public String getTimeStep() {
        return this._rec.getTimeStep();
    }

    @Override
    public String getName() {
        return this._rec.getName();
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getXAxisName() {
        if (this._rec.getType() == 1) {
            return this._parameter;
        }
        if (this._rec.getType() == 2) {
            return "Normalized Length Upstream to Downstream";
        }
        return "River Mile";
    }

    @Override
    public String getYAxisName() {
        if (this._rec.getType() == 1) {
            return "Elevation (%S)";
        }
        return this._parameter;
    }

    @Override
    public int getXAxisType() {
        return 0;
    }

    @Override
    public int getYAxisType() {
        return 0;
    }

    @Override
    public int getXParameterId() {
        if (this._rec.getType() == 1) {
            return Parameter.PARAMID_TEMP;
        }
        return -1;
    }

    @Override
    public int getYParameterId() {
        if (this._rec.getType() == 1) {
            return Parameter.PARAMID_ELEV;
        }
        return Parameter.PARAMID_TEMP;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this._profx == null || this._profy == null) {
            return null;
        }
        if (this._bounds == null) {
            this._bounds = new WorldRect();
            float xmin = Float.MAX_VALUE;
            float xmax = Float.MIN_VALUE;
            float ymin = Float.MAX_VALUE;
            float ymax = Float.MIN_VALUE;
            for (int i = 0; i < this._profx.length; ++i) {
                if (!RMAConst.isValidValue(this._profx[i])) continue;
                if (xmin > this._profx[i]) {
                    xmin = this._profx[i];
                }
                if (xmax < this._profx[i]) {
                    xmax = this._profx[i];
                }
                if (RMAConst.isValidValue(this._profy[i]) && ymin > this._profy[i]) {
                    ymin = this._profy[i];
                }
                if (!RMAConst.isValidValue(this._profy[i]) || !(ymax < this._profy[i])) continue;
                ymax = this._profy[i];
            }
            float[] paramBounds = this._rec.getParameterBounds(this._parameter);
            if (paramBounds != null) {
                ymin = paramBounds[0];
                ymax = paramBounds[1];
            }
            if (this._rec.getType() == 1) {
                this._bounds.s = xmin;
                this._bounds.n = xmax;
                this._bounds.w = ymin;
                this._bounds.e = ymax;
            } else {
                this._bounds.w = xmin;
                this._bounds.e = xmax;
                this._bounds.s = ymin;
                this._bounds.n = ymax;
            }
        }
        return this._bounds;
    }

    static {
        G2dGlyphFactory.addMapping(ProfileDataG2dObject.class, ProfileDataG2dGlyph.class);
    }
}

