/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.bar;

import java.util.Comparator;
import java.util.Objects;

public class BarData {
    private final int _streamOrder;
    private final String _location;
    private ValueQualityPair _value;
    private static final Integer MISSING_QUALITY = -1;

    public BarData(int streamOrder, String location) {
        this._location = location;
        this._streamOrder = streamOrder;
        this._value = new ValueQualityPair(0.0, MISSING_QUALITY);
    }

    public String getLocation() {
        return this._location;
    }

    public int getStreamOrder() {
        return this._streamOrder;
    }

    public void setValue(Double value) {
        this._value = new ValueQualityPair(value, MISSING_QUALITY);
    }

    public void setValue(Double value, Integer quality) {
        this._value = new ValueQualityPair(value, quality);
    }

    public void updateQuality(Integer quality) {
        this._value.setQuality(quality);
    }

    public Double getValue() {
        return this._value.getValue();
    }

    public Integer getQuality() {
        return this._value.getQuality();
    }

    public void copy(BarData data) {
        this.setValue(data.getValue(), data.getQuality());
    }

    public static Comparator<BarData> streamComparator(boolean upstream) {
        return (o1, o2) -> {
            int upstreamOrdering = upstream ? -1 : 1;
            return upstreamOrdering * Integer.compare(o1.getStreamOrder(), o2.getStreamOrder());
        };
    }

    public static Comparator<BarData> valueComparator(boolean reverse) {
        return (o1, o2) -> {
            int ordering = reverse ? -1 : 1;
            return ordering * Double.compare(o1.getValue(), o2.getValue());
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BarData)) {
            return false;
        }
        BarData barData = (BarData)o;
        return this._streamOrder == barData._streamOrder && Objects.equals(this._location, barData._location) && Objects.equals(this._value, barData._value);
    }

    public int hashCode() {
        return Objects.hash(this._streamOrder, this._location, this._value);
    }

    private static class ValueQualityPair {
        private final Double _value;
        private Integer _quality;

        public ValueQualityPair(Double value, Integer quality) {
            this._value = value;
            this._quality = quality;
        }

        public Double getValue() {
            return this._value;
        }

        public void setQuality(Integer quality) {
            this._quality = quality;
        }

        public Integer getQuality() {
            return this._quality;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValueQualityPair)) {
                return false;
            }
            ValueQualityPair that = (ValueQualityPair)o;
            return Objects.equals(this._value, that._value) && Objects.equals(this._quality, that._quality);
        }

        public int hashCode() {
            return Objects.hash(this._value, this._quality);
        }
    }
}

