/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.bar;

import hec.geometry.Scale;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.Viewport;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import rma.util.FillPatternFactory;

public abstract class BarGlyph
extends G2dGlyph {
    private static final double ROTATE_LABEL_ANGLE = Math.toRadians(-60.0);

    public BarGlyph(Viewport view, G2dObject map, Scale scl) {
        super(view, map, scl);
    }

    protected final void drawRectWithProperties(Graphics g, Rectangle2D rect, G2dLineProperties lineProp, Double value) {
        this.fillArea(g, rect, lineProp);
        this.drawRectLine(rect, lineProp, g);
        if (this.showLabel()) {
            this.drawTextForBar(g, rect, value, lineProp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawRectLine(Rectangle2D rect, G2dLineProperties lineProp, Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            g2d.setStroke(new BasicStroke(lineProp.getLineWidth(), lineProp._endStyle, 0, 10.0f, lineProp.getLinePattern(), 0.0f));
            g2d.setColor(lineProp.getLineColor());
            g2d.draw(rect);
        }
        finally {
            g2d.dispose();
        }
    }

    protected abstract boolean showLabel();

    protected abstract NumberFormat getValueFormatter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillArea(Graphics g, Rectangle2D rc2d, G2dLineProperties lineProp) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            g2d.setColor(lineProp.getFillColor());
            int pattern = lineProp.getFillPattern();
            if (pattern == 0) {
                g2d.fill(rc2d);
            } else {
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                Paint tp = FillPatternFactory.createFillPattern(pattern, lineProp.getFillColor());
                g2d.setPaint(tp);
                g2d.setComposite(ac);
                g2d.fill(rc2d);
            }
        }
        finally {
            g2d.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTextForBar(Graphics g, Rectangle2D bar, Double value, G2dLineProperties props) {
        Font labelFont = props.getLabelFont();
        Color labelColor = props.getLabelColor();
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            g2d.setFont(labelFont);
            g2d.setColor(labelColor);
            double centerX = bar.getCenterX();
            double minY = bar.getMinY();
            FontMetrics labelMetrics = g2d.getFontMetrics(labelFont);
            NumberFormat valueFormatter = this.getValueFormatter();
            String valueAsText = valueFormatter.format(value);
            double y = minY - (double)labelMetrics.getDescent();
            g2d.translate(centerX, y);
            g2d.rotate(ROTATE_LABEL_ANGLE);
            g2d.drawString(valueAsText, 0, 0);
            g2d.rotate(-ROTATE_LABEL_ANGLE);
            g2d.translate(-centerX, -y);
        }
        finally {
            g2d.dispose();
        }
    }
}

