/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.bar;

import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.swing.charts.bar.BarData;
import hec.gfx2d.swing.charts.bar.BarGroupGlyph;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import rma.util.RMAConst;

public class BarGroupData
extends G2dData {
    public static final String LINE_PROPERTIES_CHANGED = "linePropsChanged";
    private String _groupName;
    private int _numCategories;
    private int _numGroups;
    private int _groupIndex;
    private final List<BarData> _bars = new ArrayList<BarData>();
    private static final String X_AXIS_NAME = "Location";
    private static final int X_AXIS_TYPE = 5;
    private static final String Y_AXIS_NAME = "Value";
    private static final int Y_AXIS_TYPE = 0;
    private final PropertyChangeSupport _pcs = new PropertyChangeSupport(this);
    private boolean _showLabel;
    private final NumberFormat _valueFormatter;

    public BarGroupData() {
        this._showLabel = false;
        this._valueFormatter = new DecimalFormat("#0");
    }

    public BarGroupData(List<BarData> bars, int groupCount, int groupIndex, String groupName, boolean showLabel, NumberFormat format) {
        this._groupName = groupName;
        this._numCategories = bars.size();
        this._numGroups = groupCount;
        this._groupIndex = groupIndex;
        this._showLabel = showLabel;
        this._valueFormatter = format;
        this._bars.addAll(bars);
        this._bars.sort(BarData.streamComparator(false));
    }

    public List<BarData> getBars() {
        ArrayList<BarData> retBars = new ArrayList<BarData>();
        retBars.addAll(this._bars);
        return retBars;
    }

    public int getGroupIndex() {
        return this._groupIndex;
    }

    public void setGroupIndex(int index) {
        this._groupIndex = index;
    }

    public int getGroupCount() {
        return this._numGroups;
    }

    public void setGroupCount(int numGroups) {
        this._numGroups = numGroups;
    }

    @Override
    public String getName() {
        return this._groupName;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    public void setBars(List<BarData> bars) {
        this._bars.clear();
        this._bars.addAll(bars);
        this._bars.sort(BarData.streamComparator(false));
        this._numCategories = this._bars.size();
    }

    @Override
    public int getCurveCount() {
        return 1;
    }

    @Override
    public double[] getYValues(int curveNum) {
        double[] values = new double[this._numCategories];
        for (int i = 0; i < this._numCategories; ++i) {
            values[i] = this._bars.get(i).getValue();
        }
        return values;
    }

    @Override
    public String getXAxisName() {
        return X_AXIS_NAME;
    }

    @Override
    public String getYAxisName() {
        return Y_AXIS_NAME;
    }

    @Override
    public int getXAxisType() {
        return 5;
    }

    @Override
    public int getYAxisType() {
        return 0;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (!this._bars.isEmpty() && this.hasValidValues(this._bars)) {
            double leftCategoryBound = this._bars.get(0).getStreamOrder();
            double rightCategoryBound = this._bars.get(this._bars.size() - 1).getStreamOrder() + 1;
            ArrayList<BarData> valueSorted = new ArrayList<BarData>();
            valueSorted.addAll(this._bars);
            valueSorted.sort(BarData.valueComparator(false));
            double yBottomBound = 0.0;
            double yTopBound = ((BarData)valueSorted.get(valueSorted.size() - 1)).getValue();
            this.bounds = new WorldRect(leftCategoryBound, yTopBound, rightCategoryBound, yBottomBound);
        } else {
            this.bounds = new WorldRect(0.0, 0.0, 0.0, 0.0);
        }
        return this.bounds;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this._groupName);
        hash = 79 * hash + this._numCategories;
        hash = 79 * hash + this._numGroups;
        hash = 79 * hash + this._groupIndex;
        hash = 79 * hash + Objects.hashCode(this._bars);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BarGroupData other = (BarGroupData)obj;
        if (this._numCategories != other._numCategories) {
            return false;
        }
        if (this._numGroups != other._numGroups) {
            return false;
        }
        if (this._groupIndex != other._groupIndex) {
            return false;
        }
        if (!Objects.equals(this._groupName, other._groupName)) {
            return false;
        }
        return Objects.equals(this._bars, other._bars);
    }

    private boolean hasValidValues(List<BarData> bars) {
        boolean retVal = true;
        for (BarData bar : bars) {
            if (RMAConst.isValidValue(bar.getStreamOrder()) && RMAConst.isValidValue(bar.getValue())) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.removePropertyChangeListener(listener);
    }

    public void setLineProperties(G2dLineProperties oldProps, G2dLineProperties newProps) {
        this._pcs.firePropertyChange(LINE_PROPERTIES_CHANGED, oldProps, newProps);
    }

    public boolean showLabel() {
        return this._showLabel;
    }

    public void setShowLabel(boolean _showLabel) {
        this._showLabel = _showLabel;
    }

    public NumberFormat getValueFormatter() {
        return this._valueFormatter;
    }

    static {
        G2dGlyphFactory.addMapping(BarGroupData.class, BarGroupGlyph.class);
    }
}

