/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.bar;

import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPropertiesDlg;
import hec.gfx2d.Viewport;
import hec.gfx2d.swing.charts.bar.BarData;
import hec.gfx2d.swing.charts.bar.BarGlyph;
import hec.gfx2d.swing.charts.bar.BarGroupData;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BarGroupGlyph
extends BarGlyph {
    private final BarGroupData _data;
    private static final double SPACING = 5.0;
    private final List<Rectangle2D> _bars = new ArrayList<Rectangle2D>();
    private final double _leftFraction;
    private final double _rightFraction;

    public BarGroupGlyph(Viewport view, BarGroupData data, Scale scale) {
        super(view, data, scale);
        this._data = data;
        double groupIndex = data.getGroupIndex();
        double numGroups = data.getGroupCount();
        this._leftFraction = groupIndex / numGroups;
        this._rightFraction = (groupIndex + 1.0) / numGroups;
    }

    @Override
    protected G2dLine createG2dLine() {
        return new G2dLine(){

            @Override
            public G2dPropertiesDlg editLineProperties(Window w) {
                G2dLineProperties oldProps = BarGroupGlyph.this._line.getProperties().clone();
                G2dPropertiesDlg dlg = super.editLineProperties(w);
                dlg.addOKListener(evt -> {
                    if (evt.getID() == G2dPropertiesDlg.APPLY_BUTTON_ACTION || evt.getID() == G2dPropertiesDlg.OK_BUTTON_ACTION) {
                        BarGroupGlyph.this._data.setLineProperties(oldProps, BarGroupGlyph.this._line.getProperties());
                    }
                });
                return dlg;
            }
        };
    }

    @Override
    protected List getOKListeners() {
        G2dLineProperties oldProps = this._line.getProperties().clone();
        return Collections.singletonList(evt -> {
            if (evt.getID() == G2dPropertiesDlg.APPLY_BUTTON_ACTION || evt.getID() == G2dPropertiesDlg.OK_BUTTON_ACTION) {
                this._data.setLineProperties(oldProps, this._line.getProperties());
            }
        });
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            this.drawBars(g2d);
        }
        finally {
            g2d.dispose();
        }
    }

    private void drawBars(Graphics2D g2d) {
        G2dGlyphDrawProp glyphProp = this.getProperties();
        G2dLineProperties lineProp = (G2dLineProperties)glyphProp.lineProperties.get(0);
        this._bars.clear();
        if (lineProp._drawLine) {
            for (BarData bar : this._data.getBars()) {
                double globalBarLeft = (double)bar.getStreamOrder() + this._leftFraction;
                double globalBarRight = (double)bar.getStreamOrder() + this._rightFraction;
                double localLeft = (double)this._scale.e2x(globalBarLeft) + 5.0;
                double localRight = (double)this._scale.e2x(globalBarRight) - 5.0;
                double localWidth = localRight - localLeft;
                if (localWidth < 10.0) {
                    localWidth = 10.0;
                }
                double barY = this._scale.n2y(bar.getValue());
                double bottomY = (double)this._scale.n2y(0.0) - barY;
                Rectangle2D.Double rc2d = new Rectangle2D.Double(localLeft, barY, localWidth, bottomY);
                this._bars.add(rc2d);
                this.drawRectWithProperties(g2d, rc2d, lineProp, bar.getValue());
            }
        }
    }

    @Override
    public boolean dataAtPoint(LocalPt point) {
        boolean retVal = false;
        for (Rectangle2D rc2d : this._bars) {
            if (!rc2d.contains(point.x, point.y)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    @Override
    public boolean objectPopupMenu(LocalPt point, int modifiers) {
        boolean retVal = false;
        if (this.dataAtPoint(point)) {
            G2dLine tempLine = this.createG2dLine();
            tempLine.setGlyph(this);
            tempLine.setScale(this._scale);
            tempLine.setName(this.getName());
            tempLine.setProperties((G2dLineProperties)this.getProperties().lineProperties.get(0));
            tempLine.showPopup(this._viewport, point.x, point.y);
            retVal = true;
        }
        return retVal;
    }

    @Override
    protected boolean showLabel() {
        return this._data.showLabel();
    }

    @Override
    protected NumberFormat getValueFormatter() {
        return this._data.getValueFormatter();
    }

    @Override
    public WorldRect getBounds() {
        WorldRect rect = super.getBounds();
        if (this._data.showLabel()) {
            rect.n *= 1.25;
        }
        return rect;
    }
}

