/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.bar;

import hec.geometry.CategoryAxis;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.Viewport;
import hec.gfx2d.swing.charts.bar.BarData;
import hec.gfx2d.swing.charts.bar.BarGroupData;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.JFrame;
import rma.swing.ColorProducer;

public class G2dBarPlot
extends G2dPanel {
    private List<BarGroupData> _barGroupData;
    private List _barProperties;

    public G2dBarPlot() {
        this.setLayout(new GridBagLayout());
        this.buildDefaultComponents();
    }

    @Override
    public void buildComponents(List objects) {
        this.buildComponents(objects, true, true);
    }

    @Override
    public void buildComponents(List objects, boolean addToolbar, boolean addLegend) {
        if (objects == null || objects.size() < 1) {
            this.buildDefaultComponents();
        } else {
            List objectProperties = this.updateForMissingObjectProperties(new ArrayList(), objects.size());
            this.buildComponents(objects, objectProperties, addToolbar, addLegend);
        }
    }

    @Override
    public void buildComponents(List objects, List objectProperties) {
        this.buildComponents(objects, objectProperties, true, true);
    }

    @Override
    public void buildDefaultComponents() {
        if (this._barGroupData == null || !this._barGroupData.isEmpty()) {
            if (this._barGroupData == null) {
                this._barGroupData = new ArrayList<BarGroupData>();
            }
            this._barGroupData.clear();
            super.buildDefaultComponents();
        }
    }

    @Override
    public void buildComponents(List objects, List objectProperties, boolean addToolbar, boolean addLegend) {
        if (objects == null || objects.size() < 1) {
            this.buildDefaultComponents();
        } else if (!Objects.equals(this._barGroupData, objects) || !Objects.equals(this._barProperties, objectProperties)) {
            this._barGroupData = objects;
            this._barProperties = this.updateForMissingObjectProperties(objectProperties, objects.size());
            super.buildComponents(objects, this._barProperties, addToolbar, addLegend);
            this.establishCategories(objects);
        }
    }

    private List updateForMissingObjectProperties(List objectProperties, int expectedSize) {
        ArrayList retObjectProperties = new ArrayList();
        Iterator iterator = objectProperties.iterator();
        while (iterator.hasNext()) {
            Object obj;
            Object nObj = obj = iterator.next();
            if (obj instanceof G2dLineProperties) {
                nObj = ((G2dLineProperties)obj).clone();
            }
            retObjectProperties.add(nObj);
        }
        if (retObjectProperties.size() < expectedSize) {
            ColorProducer producer = new ColorProducer();
            producer.restart(retObjectProperties.size());
            for (int remaining = expectedSize - retObjectProperties.size(); remaining > 0; --remaining) {
                retObjectProperties.add(producer.next());
            }
        }
        return retObjectProperties;
    }

    private void establishCategories(List objects) {
        HashMap<Integer, String> categoryNames = new HashMap<Integer, String>();
        for (Object o : objects) {
            if (!(o instanceof BarGroupData)) continue;
            BarGroupData barGroup = (BarGroupData)o;
            for (BarData bar : barGroup.getBars()) {
                categoryNames.put(bar.getStreamOrder(), bar.getLocation());
            }
        }
        Viewport primaryViewport = this.getViewports()[0];
        CategoryAxis axis = (CategoryAxis)primaryViewport.getAxis("x1");
        axis.setCategoryNames(categoryNames);
    }

    public static void main(String[] args) {
        ArrayList<BarGroupData> items = new ArrayList<BarGroupData>();
        ArrayList<BarData> barDataGroup0 = new ArrayList<BarData>();
        BarData barData1 = new BarData(0, "ACTT2");
        BarData barData2 = new BarData(1, "LEWT2");
        BarData barData3 = new BarData(2, "ACTT2");
        BarData barData4 = new BarData(3, "LEWT2");
        BarData barData5 = new BarData(4, "ACTT2");
        BarData barData6 = new BarData(5, "LEWT2");
        BarData barData7 = new BarData(6, "ACTT2");
        BarData barData8 = new BarData(7, "LEWT2");
        BarData barData9 = new BarData(8, "ACTT2");
        BarData barData10 = new BarData(9, "LEWT2");
        BarData barData11 = new BarData(10, "ACTT2");
        BarData barData12 = new BarData(11, "LEWT2");
        BarData barData13 = new BarData(12, "ACTT2");
        BarData barData14 = new BarData(13, "LEWT2");
        BarData barData15 = new BarData(14, "ACTT2");
        BarData barData16 = new BarData(15, "LEWT2");
        barData1.setValue(10.0);
        barData2.setValue(20.0);
        barData3.setValue(15.0);
        barData4.setValue(160.0);
        barData5.setValue(1.0);
        barData6.setValue(10.0);
        barData7.setValue(95.0);
        barData8.setValue(50.0);
        barData9.setValue(75.0);
        barData10.setValue(30.0);
        barData11.setValue(88.0);
        barData12.setValue(44.0);
        barData13.setValue(16.0);
        barData14.setValue(126.0);
        barData15.setValue(140.0);
        barData16.setValue(101.0);
        barDataGroup0.add(barData1);
        barDataGroup0.add(barData2);
        barDataGroup0.add(barData3);
        barDataGroup0.add(barData4);
        barDataGroup0.add(barData5);
        barDataGroup0.add(barData6);
        barDataGroup0.add(barData7);
        barDataGroup0.add(barData8);
        barDataGroup0.add(barData9);
        barDataGroup0.add(barData10);
        barDataGroup0.add(barData11);
        barDataGroup0.add(barData12);
        barDataGroup0.add(barData13);
        barDataGroup0.add(barData14);
        barDataGroup0.add(barData15);
        barDataGroup0.add(barData16);
        ArrayList<BarData> barDataGroup1 = new ArrayList<BarData>();
        barDataGroup1.add(barData1);
        barDataGroup1.add(barData2);
        barDataGroup1.add(barData3);
        barDataGroup1.add(barData4);
        barDataGroup1.add(barData5);
        barDataGroup1.add(barData6);
        barDataGroup1.add(barData7);
        barDataGroup1.add(barData8);
        barDataGroup1.add(barData9);
        barDataGroup1.add(barData10);
        barDataGroup1.add(barData11);
        barDataGroup1.add(barData12);
        barDataGroup1.add(barData13);
        barDataGroup1.add(barData14);
        barDataGroup1.add(barData15);
        barDataGroup1.add(barData16);
        BarGroupData group0 = new BarGroupData(barDataGroup0, 2, 0, "totals", false, new DecimalFormat("0#"));
        BarGroupData group1 = new BarGroupData(barDataGroup1, 2, 1, "used", false, new DecimalFormat("0#"));
        group0.addPropertyChangeListener(evt -> System.out.println("Received event0: " + evt.getPropertyName()));
        group1.addPropertyChangeListener(evt -> System.out.println("Received event1: " + evt.getPropertyName()));
        items.add(group0);
        items.add(group1);
        G2dBarPlot barPlot = new G2dBarPlot();
        barPlot.buildComponents(items);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add(barPlot);
        frame.setSize(300, 300);
        frame.setVisible(true);
    }
}

