/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.color;

import hec.gfx2d.swing.charts.color.BandedColor;
import hec.gfx2d.swing.charts.color.ColorTable;
import hec.gfx2d.swing.charts.color.ColorTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;

public class ColorConfigDialog
extends JDialog {
    private final boolean _twoColor;
    private final List<BandedColor> _savedColors = new ArrayList<BandedColor>();
    private ColorTableModel _colorTableModel;
    private ColorTable _colorTable;
    private BandedColor _selectedColor;
    private RmaJButton _newButton;
    private RmaJButton _removeButton;
    private RmaJButton _okButton;
    private RmaJButton _cancelButton;

    public ColorConfigDialog(Component callingComponent, boolean twoColor) {
        this.setLocationRelativeTo(callingComponent);
        this._twoColor = twoColor;
        this.buildComponents();
        this.addListeners();
        this.pack();
        this.revalidate();
        this.setMinimumSize(this.getPreferredSize());
    }

    public void setBandedColorComparator(Comparator<BandedColor> comparator) {
        this._colorTableModel.setComparator(comparator);
    }

    public static void main(String[] args) {
        ColorConfigDialog dlg = new ColorConfigDialog(null, false);
        dlg.setModal(true);
        ArrayList<BandedColor> colors = new ArrayList<BandedColor>();
        colors.add(new BandedColor(Color.yellow, 1.0));
        colors.add(new BandedColor(Color.blue, 3.0));
        colors.add(new BandedColor(Color.green, 2.0));
        dlg.fillColors(colors);
        dlg.setVisible(true);
        System.exit(0);
    }

    public boolean isTwoColor() {
        return this._twoColor;
    }

    public List<BandedColor> getColors() {
        return this._savedColors;
    }

    public void fillTwoColors(List<Color> colors) {
        ArrayList<BandedColor> bandedColors = new ArrayList<BandedColor>();
        double dist = 0.0;
        for (Color c2 : colors) {
            bandedColors.add(new BandedColor(c2, dist));
            dist += 100.0;
        }
        this._colorTableModel.fill(bandedColors);
        this._savedColors.addAll(bandedColors);
    }

    public void fillColors(List<BandedColor> bandedColors) {
        this._colorTableModel.fill(bandedColors);
        this._savedColors.addAll(bandedColors);
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this.setTitle("Configure Chart Color");
        this._colorTableModel = new ColorTableModel();
        this._colorTableModel.fill(new ArrayList<BandedColor>());
        this._colorTableModel.setDistEditable(!this._twoColor);
        this._colorTable = new ColorTable(this._colorTableModel);
        JScrollPane tablePane = new JScrollPane(this._colorTable, 20, 31);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)tablePane, gbc);
        if (!this._twoColor) {
            this.buildAddRemoveButtons();
        }
        this.buildOkCancelButtons();
    }

    private void buildAddRemoveButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this._newButton = new RmaJButton();
        this._newButton.setText("Add");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this._newButton, gbc);
        this._removeButton = new RmaJButton();
        this._removeButton.setText("Remove");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        buttonPanel.add((Component)this._removeButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.fill = 3;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)buttonPanel, gbc);
    }

    private void buildOkCancelButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this._okButton = new RmaJButton();
        this._okButton.setText("OK");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.INSETS5505;
        buttonPanel.add((Component)this._okButton, gbc);
        this._cancelButton = new RmaJButton();
        this._cancelButton.setText("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.INSETS5505;
        buttonPanel.add((Component)this._cancelButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 13;
        this.add((Component)buttonPanel, gbc);
    }

    private void updateOkButton() {
        boolean isValid = this._colorTableModel.isValidForSave();
        this._okButton.setEnabled(isValid);
        String tooltip = null;
        if (!isValid) {
            tooltip = "% must be entirely filled before saving.";
        }
        this._okButton.setToolTipText(tooltip);
    }

    private void addListeners() {
        if (!this._twoColor) {
            this._newButton.addActionListener(e -> {
                BandedColor color = new BandedColor(Color.WHITE, null);
                this._colorTable.commitEdit(true);
                this._colorTableModel.insertEntry(color);
            });
            this._removeButton.addActionListener(e -> {
                BandedColor color = this._selectedColor;
                this._colorTable.commitEdit(true);
                this._colorTableModel.removeEntry(color);
            });
        }
        this._okButton.addActionListener(e -> {
            this._colorTable.commitEdit(true);
            if (this._colorTableModel.isValidForSave()) {
                this.saveColors();
                this.setVisible(false);
            }
        });
        this._cancelButton.addActionListener(e -> this.setVisible(false));
        this._colorTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateSelectedEntry();
        });
        this._colorTableModel.addTableModelListener(evt -> this.updateOkButton());
    }

    private void updateSelectedEntry() {
        int selectedRow = this._colorTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < this._colorTable.getRowCount()) {
            this._selectedColor = this._colorTableModel.getEntryForRow(selectedRow);
            if (this._removeButton != null) {
                this._removeButton.setEnabled(true);
            }
        } else {
            this._selectedColor = null;
            if (this._removeButton != null) {
                this._removeButton.setEnabled(false);
            }
        }
    }

    private void saveColors() {
        this._savedColors.clear();
        this._savedColors.addAll(this._colorTableModel.getAllEntries());
    }
}

