/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.color;

import hec.gfx2d.swing.charts.color.BandedColor;
import hec.gfx2d.swing.charts.color.ColorConfigDialog;
import hec.gfx2d.swing.charts.color.ColorContourType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JSlider;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorChooserButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.util.BandedColorContour;
import rma.util.Clipping;
import rma.util.ColorContour;
import rma.util.GrayscaleColorContour;
import rma.util.LinearColorContour;
import rma.util.PrecipColorContour;
import rma.util.RGBColorContour;
import rma.util.TerrainColorContour;
import rma.util.TwoColorColorContour;
import rma.util.WaterDepthColorContour;
import rma.util.contour.ColorContourJPanel;
import rma.util.contour.ColorContourRecord;
import rma.util.contour.PieChartColorContourRecord;

public class ColorContourOptionsPanel
extends RmaJPanel {
    private RmaJPanel _configurationPanel;
    private RmaJComboBox<ColorContourType> _typeOptionBox;
    private RmaJColorChooserButton _baseColorButton;
    private RmaJCheckBox _reversedCheckbox;
    private RmaJButton _configureColorButton;
    private static final int MIN_INDEX = 0;
    private static final int MAX_INDEX = 1;
    private final List<Color> _twoColors = new ArrayList<Color>();
    private final List<BandedColor> _bandedColors = new ArrayList<BandedColor>();
    private RmaJDecimalField _maxLimitField;
    private RmaJDecimalField _minLimitField;
    private RmaJDecimalField _ticIntervalField;
    private JSlider _brightnessSlider;
    private RmaJDecimalField _brightnessField;
    private JSlider _saturationSlider;
    private RmaJDecimalField _saturationField;
    private JSlider _alphaSlider;
    private RmaJDecimalField _alphaField;
    private RmaJCheckBox _adjustColorClippingCheckbox;
    private RmaJCheckBox _useMaxClippingCheckbox;
    private JSlider _maxClippingSlider;
    private RmaJIntegerField _maxClippingField;
    private RmaJCheckBox _useMinClippingCheckbox;
    private JSlider _minClippingSlider;
    private RmaJIntegerField _minClippingField;
    private ColorContourJPanel _scalePanel;

    public ColorContourOptionsPanel() {
        this.buildComponents();
        this.addListeners();
    }

    public ColorContourType getContourType() {
        return (ColorContourType)((Object)this._typeOptionBox.getItemAt(this._typeOptionBox.getSelectedIndex()));
    }

    public void loadContour(ColorContourRecord contourRecord, ColorContourType type) {
        ColorContour contour = contourRecord.getColorContour();
        this._maxLimitField.setEditable(true);
        this._minLimitField.setEditable(true);
        this.loadConfigurationPanel(contour, type);
        this._configurationPanel.revalidate();
        this._configurationPanel.repaint();
        this._maxLimitField.setValue(contour.getMaxValue());
        this._minLimitField.setValue(contour.getMinValue());
        this._ticIntervalField.setValue(contourRecord.getTicInterval());
        this._brightnessSlider.setValue((int)Math.round(contour.getBrightness() * 100.0));
        this._brightnessField.setValue(contour.getBrightness());
        this._saturationSlider.setValue((int)Math.round(contour.getSaturation() * 100.0));
        this._saturationField.setValue(contour.getSaturation());
        this._alphaSlider.setValue(Math.round(contourRecord.getAlpha() * 100.0f));
        this._alphaField.setValue(contourRecord.getAlpha());
        this._adjustColorClippingCheckbox.setSelected(contour.getScaleToClipping());
        this._useMaxClippingCheckbox.setSelected(contour.getMaxClipping().getEnabled());
        this._maxClippingSlider.setValue((int)Math.round(contour.getMaxClipping().getValue()));
        this._maxClippingSlider.setEnabled(this._useMaxClippingCheckbox.isSelected());
        this._maxClippingField.setValue(this._maxClippingSlider.getValue());
        this._maxClippingField.setEnabled(this._useMaxClippingCheckbox.isSelected());
        this._useMinClippingCheckbox.setSelected(contour.getMinClipping().getEnabled());
        this._minClippingSlider.setValue((int)Math.round(contour.getMinClipping().getValue()));
        this._minClippingSlider.setEnabled(this._useMinClippingCheckbox.isSelected());
        this._minClippingField.setValue(this._minClippingSlider.getValue());
        this._minClippingField.setEnabled(this._useMinClippingCheckbox.isSelected());
        this.updateScale();
        this._scalePanel.setDataRecord(contourRecord);
        this._scalePanel.revalidate();
        this._scalePanel.repaint();
        this.revalidate();
        this.repaint();
    }

    private void loadConfigurationPanel(ColorContour contour, ColorContourType type) {
        this.removeAllConfigurationButtons();
        this._typeOptionBox.setSelectedItem((Object)type);
        switch (type) {
            case LINEAR: {
                this.attachBaseColorButton();
                this.attachReverseCheckBox();
                this.loadLinearContour((LinearColorContour)contour);
                break;
            }
            case TWO_COLOR: {
                this.attachConfigColorButton();
                this.loadTwoColorContour((TwoColorColorContour)contour);
                break;
            }
            case BANDED: {
                this.attachConfigColorButton();
                this.loadBandedContour((BandedColorContour)contour);
                break;
            }
        }
    }

    private void loadLinearContour(LinearColorContour contour) {
        this._baseColorButton.setColor(contour.getColor());
        this._reversedCheckbox.setSelected(contour.isReversed());
    }

    private void loadTwoColorContour(TwoColorColorContour contour) {
        this._twoColors.clear();
        this._twoColors.add(0, contour.getMinColor());
        this._twoColors.add(1, contour.getMaxColor());
    }

    private void loadBandedContour(BandedColorContour contour) {
        this._bandedColors.clear();
        for (Double index : contour.getIndexes()) {
            this._bandedColors.add(new BandedColor(contour.getColorAtIndex(index), index));
        }
        contour.setMaxValue((Double)contour.getIndexes().first());
        contour.setMinValue((Double)contour.getIndexes().last());
        this._maxLimitField.setEditable(false);
        this._minLimitField.setEditable(false);
    }

    public ColorContourRecord saveContour() {
        ColorContour contour;
        switch ((ColorContourType)((Object)this._typeOptionBox.getItemAt(this._typeOptionBox.getSelectedIndex()))) {
            case LINEAR: {
                contour = new LinearColorContour();
                this.saveLinearContour((LinearColorContour)contour);
                break;
            }
            case RGB: {
                contour = new RGBColorContour();
                break;
            }
            case WATER_DEPTH: {
                contour = new WaterDepthColorContour();
                break;
            }
            case PRECIPITATION: {
                contour = new PrecipColorContour();
                break;
            }
            case GRAY_SCALE: {
                contour = new GrayscaleColorContour();
                break;
            }
            case TERRAIN: {
                contour = new TerrainColorContour();
                break;
            }
            case TWO_COLOR: {
                contour = new TwoColorColorContour();
                this.saveTwoColorContour((TwoColorColorContour)contour);
                break;
            }
            default: {
                contour = BandedColorContour.buildSwtBandedColor();
                this.saveBandedContour((BandedColorContour)contour);
            }
        }
        contour.setMaxValue(this._maxLimitField.getValue());
        contour.setMinValue(this._minLimitField.getValue());
        contour.setBrightness(this._brightnessField.getValue());
        contour.setSaturation(this._saturationField.getValue());
        contour.setScaleToClipping(this._adjustColorClippingCheckbox.isSelected());
        Clipping maxClipping = new Clipping();
        maxClipping.setEnabled(this._useMaxClippingCheckbox.isSelected());
        maxClipping.setValue(this._maxClippingField.getValueAsDbl());
        Clipping minClipping = new Clipping();
        minClipping.setEnabled(this._useMinClippingCheckbox.isSelected());
        minClipping.setValue(this._minClippingField.getValueAsDbl());
        contour.setMaxClipping(maxClipping);
        contour.setMinClipping(minClipping);
        float alpha = (float)this._alphaField.getValue();
        double ticInterval = this._ticIntervalField.getValue();
        return new PieChartColorContourRecord(contour, alpha, ticInterval);
    }

    private void saveLinearContour(LinearColorContour contour) {
        contour.setColor(this._baseColorButton.getColor());
        contour.setReverse(this._reversedCheckbox.isSelected());
    }

    private void saveTwoColorContour(TwoColorColorContour contour) {
        if (this._twoColors.size() == 2) {
            contour.setMinColor(this._twoColors.get(0));
            contour.setMaxColor(this._twoColors.get(1));
        }
    }

    private void saveBandedContour(BandedColorContour contour) {
        for (BandedColor bandedColor : this._bandedColors) {
            contour.setColorAtIndex(bandedColor.getDist(), bandedColor.getColor());
        }
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        RmaJPanel leftPane = this.buildLeftPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)leftPane, gbc);
        this._scalePanel = new ColorContourJPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._scalePanel, gbc);
    }

    private RmaJPanel buildLeftPane() {
        RmaJPanel leftPane = new RmaJPanel();
        leftPane.setLayout(new GridBagLayout());
        this._configurationPanel = this.buildConfigurationPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        leftPane.add((Component)this._configurationPanel, gbc);
        RmaJPanel contourLimitsPanel = this.buildContourLimitsPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        leftPane.add((Component)contourLimitsPanel, gbc);
        RmaJPanel contourPropertiesPanel = this.buildContourPropertiesPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        leftPane.add((Component)contourPropertiesPanel, gbc);
        RmaJPanel contourClippingPanel = this.buildContourClippingPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        leftPane.add((Component)contourClippingPanel, gbc);
        return leftPane;
    }

    private RmaJPanel buildConfigurationPanel() {
        RmaJPanel configPanel = new RmaJPanel();
        configPanel.setLayout(new GridBagLayout());
        this._typeOptionBox = new RmaJComboBox<ColorContourType>(ColorContourType.values());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        configPanel.add(this._typeOptionBox, gbc);
        this._baseColorButton = new RmaJColorChooserButton();
        this._baseColorButton.setText("Base Color");
        this._reversedCheckbox = new RmaJCheckBox();
        this._reversedCheckbox.setText("Reversed");
        this._configureColorButton = new RmaJButton();
        this._configureColorButton.setText("Configure Colors");
        return configPanel;
    }

    private RmaJPanel buildContourLimitsPanel() {
        RmaJPanel contourLimitsPanel = new RmaJPanel();
        contourLimitsPanel.setLayout(new GridBagLayout());
        contourLimitsPanel.setBorder(BorderFactory.createTitledBorder("Contour Limits"));
        RmaJLabel maxLimitLabel = new RmaJLabel();
        maxLimitLabel.setText("Maximum:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        contourLimitsPanel.add((Component)maxLimitLabel, gbc);
        this._maxLimitField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourLimitsPanel.add((Component)this._maxLimitField, gbc);
        RmaJLabel minLimitLabel = new RmaJLabel();
        minLimitLabel.setText("Minimum:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        contourLimitsPanel.add((Component)minLimitLabel, gbc);
        this._minLimitField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourLimitsPanel.add((Component)this._minLimitField, gbc);
        return contourLimitsPanel;
    }

    private RmaJPanel buildContourPropertiesPanel() {
        RmaJPanel contourPropPanel = new RmaJPanel();
        contourPropPanel.setLayout(new GridBagLayout());
        contourPropPanel.setBorder(BorderFactory.createTitledBorder("Contour Color Properties"));
        RmaJLabel ticIntervalLabel = new RmaJLabel();
        ticIntervalLabel.setText("Tic Interval:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)ticIntervalLabel, gbc);
        this._ticIntervalField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)this._ticIntervalField, gbc);
        RmaJLabel brightnessLabel = new RmaJLabel();
        brightnessLabel.setText("Brightness (0.0-1.0):");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)brightnessLabel, gbc);
        this._brightnessSlider = new JSlider();
        this._brightnessSlider.setSnapToTicks(false);
        this._brightnessSlider.setPaintTicks(false);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)this._brightnessSlider, gbc);
        this._brightnessField = new RmaJDecimalField();
        this._brightnessField.setMinValue(0.0);
        this._brightnessField.setMaxValue(1.0);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)this._brightnessField, gbc);
        RmaJLabel saturationLabel = new RmaJLabel();
        saturationLabel.setText("Saturation (0.0-1.0):");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)saturationLabel, gbc);
        this._saturationSlider = new JSlider();
        this._saturationSlider.setSnapToTicks(false);
        this._saturationSlider.setPaintTicks(false);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)this._saturationSlider, gbc);
        this._saturationField = new RmaJDecimalField();
        this._saturationField.setMinValue(0.0);
        this._saturationField.setMaxValue(1.0);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)this._saturationField, gbc);
        RmaJLabel alphaLabel = new RmaJLabel();
        alphaLabel.setText("Alpha (0.0-1.0):");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 13;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)alphaLabel, gbc);
        this._alphaSlider = new JSlider();
        this._alphaSlider.setSnapToTicks(false);
        this._alphaSlider.setPaintTicks(false);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)this._alphaSlider, gbc);
        this._alphaField = new RmaJDecimalField();
        this._alphaField.setMinValue(0.0);
        this._alphaField.setMaxValue(1.0);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourPropPanel.add((Component)this._alphaField, gbc);
        return contourPropPanel;
    }

    private RmaJPanel buildContourClippingPanel() {
        RmaJPanel contourClippingPanel = new RmaJPanel();
        contourClippingPanel.setLayout(new GridBagLayout());
        contourClippingPanel.setBorder(BorderFactory.createTitledBorder("Contour Clipping"));
        this._adjustColorClippingCheckbox = new RmaJCheckBox();
        this._adjustColorClippingCheckbox.setText("Adjust Color Scale to Clipping Area");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        contourClippingPanel.add((Component)this._adjustColorClippingCheckbox, gbc);
        this._useMaxClippingCheckbox = new RmaJCheckBox();
        this._useMaxClippingCheckbox.setText("Max Clipping Value:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        contourClippingPanel.add((Component)this._useMaxClippingCheckbox, gbc);
        this._maxClippingSlider = new JSlider();
        this._maxClippingSlider.setSnapToTicks(false);
        this._maxClippingSlider.setPaintTicks(false);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourClippingPanel.add((Component)this._maxClippingSlider, gbc);
        this._maxClippingField = new RmaJIntegerField();
        this._maxClippingField.setMinValue(0);
        this._maxClippingField.setMaxValue(100);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourClippingPanel.add((Component)this._maxClippingField, gbc);
        this._useMinClippingCheckbox = new RmaJCheckBox();
        this._useMinClippingCheckbox.setText("Min Clipping Value:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        contourClippingPanel.add((Component)this._useMinClippingCheckbox, gbc);
        this._minClippingSlider = new JSlider();
        this._minClippingSlider.setSnapToTicks(false);
        this._minClippingSlider.setPaintTicks(false);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourClippingPanel.add((Component)this._minClippingSlider, gbc);
        this._minClippingField = new RmaJIntegerField();
        this._minClippingField.setMinValue(0);
        this._minClippingField.setMaxValue(100);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        contourClippingPanel.add((Component)this._minClippingField, gbc);
        return contourClippingPanel;
    }

    private void removeAllConfigurationButtons() {
        this._configurationPanel.remove(this._baseColorButton);
        this._configurationPanel.remove(this._reversedCheckbox);
        this._configurationPanel.remove(this._configureColorButton);
    }

    private void attachBaseColorButton() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this._configurationPanel.add((Component)this._baseColorButton, gbc);
    }

    private void attachReverseCheckBox() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this._configurationPanel.add((Component)this._reversedCheckbox, gbc);
    }

    private void attachConfigColorButton() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this._configurationPanel.add((Component)this._configureColorButton, gbc);
    }

    private void addListeners() {
        this._typeOptionBox.addActionListener(e -> {
            this._typeOptionBox.setSelectedItem(this._typeOptionBox.getSelectedIndex());
            this.reloadRecord();
        });
        PropertyChangeListener scalePanelListener = evt -> {
            if (evt.getPropertyName().equals("RmaJColorChooserButton.Property.Color")) {
                this._baseColorButton.setColor((Color)evt.getNewValue());
                this.updateScale();
            }
        };
        this._baseColorButton.addSampleListener(scalePanelListener);
        this._reversedCheckbox.addActionListener(e -> this.updateScale());
        this._configureColorButton.addActionListener(e -> {
            Dialog configDialog = null;
            switch ((ColorContourType)((Object)((Object)this._typeOptionBox.getItemAt(this._typeOptionBox.getSelectedIndex())))) {
                case TWO_COLOR: {
                    configDialog = new ColorConfigDialog(this, true);
                    ((ColorConfigDialog)configDialog).fillTwoColors(this._twoColors);
                    break;
                }
                case BANDED: {
                    configDialog = new ColorConfigDialog(this, false);
                    ((ColorConfigDialog)configDialog).fillColors(this._bandedColors);
                    break;
                }
            }
            if (configDialog != null) {
                configDialog.setModal(true);
                configDialog.setResizable(false);
                configDialog.setVisible(true);
                if (((ColorConfigDialog)configDialog).isTwoColor()) {
                    List<BandedColor> bandedColors = ((ColorConfigDialog)configDialog).getColors();
                    this._twoColors.clear();
                    this._twoColors.add(0, bandedColors.get(0).getColor());
                    this._twoColors.add(1, bandedColors.get(1).getColor());
                } else {
                    this._bandedColors.clear();
                    this._bandedColors.addAll(((ColorConfigDialog)configDialog).getColors());
                    this.reloadRecord();
                }
                this.updateScale();
            }
        });
        this._maxLimitField.addActionListener(e -> this.updateScale());
        this._minLimitField.addActionListener(e -> this.updateScale());
        this._ticIntervalField.addActionListener(e -> this.updateScale());
        this._brightnessSlider.addChangeListener(e -> {
            this._brightnessField.setValue((double)this._brightnessSlider.getValue() / 100.0);
            this.updateScale();
        });
        this._brightnessField.addActionListener(e -> {
            this._brightnessSlider.setValue((int)Math.round(this._brightnessField.getValue() * 100.0));
            this.updateScale();
        });
        this._saturationSlider.addChangeListener(e -> {
            this._saturationField.setValue((double)this._saturationSlider.getValue() / 100.0);
            this.updateScale();
        });
        this._saturationField.addActionListener(e -> {
            this._saturationSlider.setValue((int)Math.round(this._saturationField.getValue() * 100.0));
            this.updateScale();
        });
        this._alphaSlider.addChangeListener(e -> {
            this._alphaField.setValue((double)this._alphaSlider.getValue() / 100.0);
            this.updateScale();
        });
        this._alphaField.addActionListener(e -> {
            this._alphaSlider.setValue((int)Math.round(this._alphaField.getValue() * 100.0));
            this.updateScale();
        });
        this._adjustColorClippingCheckbox.addActionListener(e -> this.updateScale());
        this._useMaxClippingCheckbox.addActionListener(e -> {
            this._maxClippingSlider.setEnabled(this._useMaxClippingCheckbox.isSelected());
            this._maxClippingField.setEnabled(this._useMaxClippingCheckbox.isSelected());
            this.updateScale();
        });
        this._maxClippingSlider.addChangeListener(e -> {
            this._maxClippingField.setValue(this._maxClippingSlider.getValue());
            this.updateScale();
        });
        this._maxClippingField.addActionListener(e -> {
            this._maxClippingSlider.setValue(this._maxClippingField.getValue());
            this.updateScale();
        });
        this._useMinClippingCheckbox.addActionListener(e -> {
            this._minClippingSlider.setEnabled(this._useMinClippingCheckbox.isSelected());
            this._minClippingField.setEnabled(this._useMinClippingCheckbox.isSelected());
            this.updateScale();
        });
        this._minClippingSlider.addChangeListener(e -> {
            this._minClippingField.setValue(this._minClippingSlider.getValue());
            this.updateScale();
        });
        this._minClippingField.addActionListener(e -> {
            this._minClippingSlider.setValue(this._minClippingField.getValue());
            this.updateScale();
        });
    }

    private void reloadRecord() {
        ColorContourRecord prevRecord = this.saveContour();
        this.loadContour(prevRecord, (ColorContourType)((Object)this._typeOptionBox.getItemAt(this._typeOptionBox.getSelectedIndex())));
        this.updateScale();
    }

    private void updateScale() {
        this._scalePanel.setDataRecord(this.saveContour());
        this._scalePanel.revalidate();
        this._scalePanel.repaint();
    }
}

