/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.color;

import hec.gfx2d.swing.charts.color.BandedColor;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.RMAConst;
import rma.util.RMAIO;

class ColorTableModel
extends AbstractRmaTableModel {
    private final List<BandedColor> _colors = new ArrayList<BandedColor>();
    private boolean _distEditable = true;
    private Comparator<BandedColor> _comparator = (bc1, bc2) -> {
        Double dist1 = bc1.getDist();
        Double dist2 = bc2.getDist();
        if (dist1 == null && dist2 == null) {
            return 0;
        }
        if (dist1 == null) {
            return 1;
        }
        if (dist2 == null) {
            return -1;
        }
        return Double.compare(dist1, dist2);
    };

    ColorTableModel() {
    }

    public void setComparator(Comparator<BandedColor> _comparator) {
        this._comparator = _comparator;
    }

    void fill(List<BandedColor> colors) {
        this._colors.clear();
        this._colors.addAll(colors);
        this.sort();
        this.fireTableDataChanged();
    }

    private void sort() {
        this._colors.sort(this._comparator);
    }

    void insertEntry(BandedColor color) {
        this._colors.add(color);
        this.sort();
        this.fireTableDataChanged();
    }

    void removeEntry(BandedColor color) {
        int rowIndex = this._colors.indexOf(color);
        this._colors.remove(color);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    List<BandedColor> getAllEntries() {
        return this._colors;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return Column.getColumnString(columnIndex);
    }

    BandedColor getEntryForRow(int rowIndex) {
        return this._colors.get(rowIndex);
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return Column.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public int getRowCount() {
        return this._colors.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean retVal = false;
        Optional<Column> column = Column.getColumn(columnIndex);
        if (column.isPresent()) {
            retVal = this.isCellEditable(rowIndex, column.get());
        }
        return retVal;
    }

    boolean isCellEditable(int rowIndex, Column column) {
        return column == Column.COLOR_COL || column == Column.DIST_COL && this._distEditable;
    }

    public void setDistEditable(boolean editable) {
        this._distEditable = editable;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object retVal = null;
        Optional<Column> column = Column.getColumn(columnIndex);
        if (column.isPresent()) {
            retVal = this.getValueAt(rowIndex, column.get());
        }
        return retVal;
    }

    Object getValueAt(int rowIndex, Column column) {
        BandedColor color = this.getEntryForRow(rowIndex);
        return this.getValueInColumn(color, column);
    }

    private Object getValueInColumn(BandedColor color, Column column) {
        Serializable retVal = null;
        switch (column) {
            case COLOR_COL: {
                retVal = color.getColor();
                break;
            }
            case DIST_COL: {
                retVal = color.getDist();
            }
        }
        return retVal;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Optional<Column> optionalColumn = Column.getColumn(columnIndex);
        optionalColumn.ifPresent(column -> this.setValueAt(aValue, rowIndex, (Column)((Object)column)));
        this.validateRows();
    }

    void setValueAt(Object aValue, int rowIndex, Column column) {
        if (this.isCellEditable(rowIndex, column)) {
            BandedColor color = this.getEntryForRow(rowIndex);
            this.setValueInColumn(aValue, color, column);
        }
    }

    private void setValueInColumn(Object aValue, BandedColor color, Column column) {
        switch (column) {
            case COLOR_COL: {
                if (!(aValue instanceof Color)) break;
                color.setColor((Color)aValue);
                break;
            }
            case DIST_COL: {
                Double value = null;
                if (aValue instanceof String) {
                    double parsed = RMAIO.parseDouble(aValue.toString());
                    if (RMAConst.isValidValue(parsed)) {
                        value = parsed;
                    }
                } else if (aValue instanceof Double) {
                    value = (Double)aValue;
                }
                color.setDist(value);
            }
        }
    }

    public void setEnabled(boolean b) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.setRowEnabled(b, i);
        }
    }

    private void validateRows() {
        this.sort();
        this.fireTableDataChanged();
    }

    public boolean isValidForSave() {
        return !this._colors.stream().anyMatch(band -> band.getDist() == null);
    }

    static enum Column {
        COLOR_COL("Color", 0, Color.class),
        DIST_COL("%", 1, Float.class);

        private final String _displayName;
        private final int _index;
        private final Class _dataClass;

        private Column(String displayName, int index, Class dataClass) {
            this._displayName = displayName;
            this._index = index;
            this._dataClass = dataClass;
        }

        public final String toString() {
            return this._displayName;
        }

        final int getIndex() {
            return this._index;
        }

        final Class getDataClass() {
            return this._dataClass;
        }

        private static Optional<Column> getColumn(int index) {
            return Arrays.stream(Column.values()).filter(col -> col.getIndex() == index).findFirst();
        }

        private static String getColumnString(int index) {
            return Arrays.stream(Column.values()).filter(col -> col.getIndex() == index).map(Column::toString).findFirst().orElse("");
        }

        private static Class getColumnClass(int index) {
            return Arrays.stream(Column.values()).filter(col -> col.getIndex() == index).map(Column::getDataClass).findFirst().orElse(String.class);
        }
    }
}

