/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.data;

import hec.gfx2d.swing.charts.data.ChartRenderControls;
import hec.gfx2d.swing.charts.thresholds.Threshold;
import hec.gfx2d.swing.charts.util.PropertyFireable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import rma.xml.adapters.XmlColorAdapter;
import rma.xml.adapters.XmlFontAdapter;

@XmlRootElement(name="ChartItemRenderControls")
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class ChartItemRenderControls
implements PropertyFireable {
    public static final String PROPERTY_VISIBLE = "rmaChartItemRenderControls.visible";
    public static final String PROPERTY_LABEL_FONT = "rmaChartItemRenderControls.labelFont";
    public static final String PROPERTY_LABEL_FORMAT = "rmaChartItemRenderControls.labelFormat";
    public static final String PROPERTY_LABEL_COLOR = "rmaChartItemRenderControls.labelColor";
    public static final String PROPERTY_SHOW_LABEL = "rmaChartItemRenderControls.showLabel";
    public static final String PROPERTY_SHOW_VALUE = "rmaChartItemRenderControls.showValue";
    public static final String PROPERTY_SHOW_THRESHOLDS = "rmaChartItemRenderControls.showThresholds";
    public static final String PROPERTY_THRESHOLDS = "rmaChartItemRenderControls.thresholds";
    public static final String PROPERTY_UPDATE = "rmaChartItemRenderControls.update";
    private transient ChartRenderControls _parentControls;
    @XmlElement(name="visible")
    private boolean _visible = true;
    @XmlElement(name="labelFont")
    @XmlJavaTypeAdapter(value=XmlFontAdapter.class)
    private Font _labelFont;
    @XmlElement(name="labelFormat")
    private String _labelFormat = "<%Name%> : <%Fill%>";
    @XmlElement(name="labelColor")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    private Color _labelColor;
    @XmlElement(name="showLabel")
    private boolean _showLabel = true;
    @XmlElement(name="showValue")
    private boolean _showValue = false;
    @XmlElement(name="showThresholds")
    private boolean _showThresholds = true;
    @XmlElement(name="thresholds")
    private final List<Threshold> _thresholds = new ArrayList<Threshold>();

    public ChartItemRenderControls() {
        this._labelFont = new Font("SansSerif", 0, 14);
        this._labelColor = Color.BLACK;
    }

    public void copy(ChartItemRenderControls copy) {
        this._visible = copy.isVisible();
        this._labelFont = copy.getLabelFont();
        this._labelFormat = copy.getLabelFormat();
        this._labelColor = copy.getLabelColor();
        this._showLabel = copy.isShowLabel();
        this._showValue = copy.isShowValue();
        this._showThresholds = copy.isShowThresholds();
    }

    public ChartRenderControls getParentControls() {
        return this._parentControls;
    }

    public void setParentControls(ChartRenderControls parent) {
        this._parentControls = parent;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean visible) {
        boolean oldVal = this._visible;
        this._visible = visible;
        this.fireUpdate(PROPERTY_VISIBLE, oldVal, visible);
    }

    public Font getLabelFont() {
        return this._labelFont;
    }

    public void setLabelFont(Font labelFont) {
        Font oldVal = this._labelFont;
        this._labelFont = labelFont;
        this.fireUpdate(PROPERTY_LABEL_FONT, oldVal, labelFont);
    }

    public String getLabelFormat() {
        return this._labelFormat;
    }

    public void setLabelFormat(String labelFormat) {
        String oldVal = this._labelFormat;
        this._labelFormat = labelFormat;
        this.fireUpdate(PROPERTY_LABEL_FORMAT, oldVal, labelFormat);
    }

    public Color getLabelColor() {
        return this._labelColor;
    }

    public void setLabelColor(Color labelColor) {
        Color oldVal = this._labelColor;
        this._labelColor = labelColor;
        this.fireUpdate(PROPERTY_LABEL_COLOR, oldVal, labelColor);
    }

    public boolean isShowLabel() {
        return this._showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        boolean oldVal = this._showLabel;
        this._showLabel = showLabel;
        this.fireUpdate(PROPERTY_SHOW_LABEL, oldVal, showLabel);
    }

    public boolean isShowValue() {
        return this._showValue;
    }

    public void setShowValue(boolean showValue) {
        boolean oldVal = this._showValue;
        this._showValue = showValue;
        this.fireUpdate(PROPERTY_SHOW_VALUE, oldVal, showValue);
    }

    public boolean isShowThresholds() {
        return this._showThresholds;
    }

    public void setShowThresholds(boolean showThresholds) {
        boolean oldVal = this._showThresholds;
        this._showThresholds = showThresholds;
        this.fireUpdate(PROPERTY_SHOW_THRESHOLDS, oldVal, showThresholds);
    }

    public List<Threshold> getThresholds() {
        return this._thresholds;
    }

    public void setThresholds(List<Threshold> thresholds) {
        this._thresholds.clear();
        this._thresholds.addAll(thresholds);
        this.fireUpdate();
    }

    @Override
    public void fireUpdate(String propertyName, Object oldVal, Object newVal) {
        if (this._parentControls != null) {
            this._parentControls.fireUpdate(propertyName, oldVal, newVal);
        }
    }

    @Override
    public void fireUpdate() {
        this.fireUpdate(PROPERTY_UPDATE, false, true);
    }
}

