/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.data;

import hec.gfx2d.swing.charts.data.ChartModel;
import hec.gfx2d.swing.charts.data.ChartSnapshotsMap;
import hec.gfx2d.swing.charts.data.DefaultChartItemModel;
import hec.gfx2d.swing.charts.data.DefaultChartModel;
import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import java.util.Calendar;
import java.util.Date;

public class ChartModelFactory {
    public static ChartModel createChartModel(TimeSeriesContainer[] data) {
        RmaDataId dataId = new RmaDataId("example chart data name", "example chart location (watershed)", "example chart description");
        ChartSnapshotsMap snapshots = new ChartSnapshotsMap();
        Calendar cal = Calendar.getInstance();
        HecTime time = new HecTime(cal);
        for (TimeSeriesContainer t : data) {
            RmaDataId itemId = new RmaDataId(t.fullName, t.getLocationName(), t.getParameterName());
            for (int i = 0; i < t.times.length; ++i) {
                time.set(t.times[i]);
                time.getTimeInMillis(cal);
                Date date = cal.getTime();
                int quality = 0;
                if (t.quality != null) {
                    quality = t.quality[i];
                }
                DefaultChartItemModel model = new DefaultChartItemModel(itemId, t.values[i], t.minimumValue(), t.maxmimumValue(), quality, t.units);
                snapshots.put(date, model);
            }
        }
        return new DefaultChartModel(dataId, snapshots);
    }
}

