/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.data;

import hec.gfx2d.swing.charts.data.ChartItemRenderControls;
import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.gfx2d.swing.charts.thresholds.Threshold;
import hec.gfx2d.swing.charts.util.LegendSide;
import hec.gfx2d.swing.charts.util.PropertyFireable;
import hec.gfx2d.swing.charts.util.RoundingTool;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;
import rma.xml.adapters.XmlColorAdapter;
import rma.xml.adapters.XmlFontAdapter;

@XmlRootElement(name="ChartRenderControls")
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class ChartRenderControls<T extends ChartItemRenderControls>
implements PropertyFireable {
    public static final String PROPERTY_SHOW_LEGEND = "rmaChartRenderControls.showLegend";
    public static final String PROPERTY_LEGEND_SIDE = "rmaChartRenderControls.legendSide";
    public static final String PROPERTY_TITLE_FONT = "rmaChartRenderControls.titleFont";
    public static final String PROPERTY_TITLE_FORMAT = "rmaChartRenderControls.titleFormat";
    public static final String PROPERTY_TITLE_COLOR = "rmaChartRenderControls.titleColor";
    public static final String PROPERTY_SHOW_THRESHOLDS = "rmaChartRenderControls.showThresholds";
    public static final String PROPERTY_SHOW_THRESHOLD_VALUES = "rmaChartRenderControls.showThresholdText";
    public static final String PROPERTY_ROUNDING_STYLE = "rmaChartRenderControls.roundingStyle";
    public static final String PROPERTY_ROUNDING_PRECISION = "rmaChartRenderControls.roundingPrecision";
    public static final String PROPERTY_ITEM_CONTROLS = "rmaChartRenderControls.itemControls";
    public static final String PROPERTY_UPDATE = "rmaChartRenderControls.update";
    private transient SwingPropertyChangeSupport _propChangeFirer;
    @XmlElement(name="id")
    private RmaDataId _id;
    @XmlElement(name="showLegend")
    private boolean _showLegend;
    @XmlElement(name="legendSide")
    private LegendSide _legendSide;
    @XmlElement(name="titleFont")
    @XmlJavaTypeAdapter(value=XmlFontAdapter.class)
    private Font _titleFont;
    @XmlElement(name="titleFormat")
    private String _titleFormat;
    @XmlElement(name="titleVisible")
    private boolean _titleVisible;
    @XmlElement(name="titleColor")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    private Color _titleColor;
    @XmlElement(name="subtitleFont")
    @XmlJavaTypeAdapter(value=XmlFontAdapter.class)
    private Font _subtitleFont;
    @XmlElement(name="subtitleFormat")
    private String _subtitleFormat;
    @XmlElement(name="subtitleVisible")
    private boolean _subtitleVisible;
    @XmlElement(name="subtitleColor")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    private Color _subtitleColor;
    @XmlElement(name="footerFont")
    @XmlJavaTypeAdapter(value=XmlFontAdapter.class)
    private Font _footerFont;
    @XmlElement(name="footerFormat")
    private String _footerFormat;
    @XmlElement(name="footerVisible")
    private boolean _footerVisible;
    @XmlElement(name="footerColor")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    private Color _footerColor;
    @XmlElement(name="showThresholds")
    private boolean _showThresholds;
    @XmlElement(name="showThresholdText")
    private boolean _showThresholdText;
    @XmlElementWrapper(name="thresholds")
    @XmlElement(name="threshold")
    private final List<Threshold> _thresholds = new ArrayList<Threshold>();
    @XmlElement(name="roundingStyle")
    private RoundingTool.RoundingType _roundingStyle;
    @XmlElement(name="roundingDecimals")
    private int _roundingDecimals;
    @XmlElement(name="roundingDigits")
    private int _roundingDigits;
    @XmlElement(name="roundingSigFigs")
    private int _roundingSigFigs;
    @XmlElement(name="itemControls")
    protected T _itemControls;

    public ChartRenderControls() {
        this(null);
    }

    public ChartRenderControls(RmaDataId id) {
        this._id = id;
        this._propChangeFirer = new SwingPropertyChangeSupport(this);
        this._showLegend = true;
        this._legendSide = LegendSide.RIGHT;
        this._titleFont = new Font("SansSerif", 1, 16);
        this._titleFormat = "<%Name%> : <%Location%>";
        this._titleColor = Color.BLACK;
        this._titleVisible = true;
        this._subtitleFont = new Font("SansSerif", 1, 14);
        this._subtitleFormat = "<%Date%>";
        this._subtitleColor = Color.BLACK;
        this._subtitleVisible = true;
        this._footerFont = new Font("SansSerif", 1, 14);
        this._footerFormat = "<%Name%> Usage : <%RelativeValue%> / <%RelativeMax%> <%Units%>";
        this._footerColor = Color.BLACK;
        this._footerVisible = true;
        this._showThresholds = true;
        this._showThresholdText = true;
        this.establishDefaultThresholds();
        this._roundingStyle = RoundingTool.RoundingType.DECIMALS;
        this._roundingDecimals = 1;
        this._roundingDigits = 2;
        this._roundingSigFigs = 3;
    }

    public ChartRenderControls(RmaDataId id, T itemControls) {
        this(id);
        this.setItemControls(itemControls);
    }

    public void copy(ChartRenderControls<T> copy) {
        this._showLegend = copy.isShowLegend();
        this._legendSide = copy.getLegendSide();
        this._titleFont = copy.getTitleFont();
        this._titleFormat = copy.getTitleFormat();
        this._titleColor = copy.getTitleColor();
        this._titleVisible = copy.isTitleVisible();
        this._subtitleFont = copy.getSubtitleFont();
        this._subtitleFormat = copy.getSubtitleFormat();
        this._subtitleColor = copy.getSubtitleColor();
        this._subtitleVisible = copy.isSubtitleVisible();
        this._footerFont = copy.getFooterFont();
        this._footerFormat = copy.getFooterFormat();
        this._footerColor = copy.getFooterColor();
        this._footerVisible = copy.isFooterVisible();
        this._showThresholds = copy.isShowThresholds();
        this._showThresholdText = copy.isShowThresholdText();
        this.setThresholds(copy.getThresholds());
        this._roundingStyle = copy.getRoundingStyle();
        this._roundingDecimals = copy.getRoundingDecimals();
        this._roundingDigits = copy.getRoundingDigits();
        this._roundingSigFigs = copy.getRoundingSigFigs();
        if (this._itemControls != null && copy.getItemControls() != null) {
            ((ChartItemRenderControls)this._itemControls).copy((ChartItemRenderControls)copy.getItemControls());
        }
    }

    private void establishDefaultThresholds() {
        Threshold twentyFive = new Threshold(0.25, Threshold.ThresholdType.PORTION);
        Threshold fifty = new Threshold(0.5, Threshold.ThresholdType.PORTION);
        Threshold seventyFive = new Threshold(0.75, Threshold.ThresholdType.PORTION);
        Threshold hundred = new Threshold(1.0, Threshold.ThresholdType.PORTION);
        this._thresholds.add(twentyFive);
        this._thresholds.add(fifty);
        this._thresholds.add(seventyFive);
        this._thresholds.add(hundred);
    }

    public void addListener(PropertyChangeListener prop) {
        this._propChangeFirer.addPropertyChangeListener(prop);
    }

    public void setItemControls(T itemControls) {
        T oldVal = this._itemControls;
        this._itemControls = itemControls;
        this.fireUpdate(PROPERTY_ITEM_CONTROLS, oldVal, itemControls);
    }

    public RmaDataId getId() {
        return this._id;
    }

    public boolean isShowLegend() {
        return this._showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        boolean oldVal = this._showLegend;
        this._showLegend = showLegend;
        this.fireUpdate(PROPERTY_SHOW_LEGEND, oldVal, showLegend);
    }

    public LegendSide getLegendSide() {
        return this._legendSide;
    }

    public void setLegendSide(LegendSide legendSide) {
        LegendSide oldVal = this._legendSide;
        this._legendSide = legendSide;
        this.fireUpdate(PROPERTY_LEGEND_SIDE, (Object)oldVal, (Object)legendSide);
    }

    public Font getTitleFont() {
        return this._titleFont;
    }

    public void setTitleFont(Font titleFont) {
        Font oldVal = this._titleFont;
        this._titleFont = titleFont;
        this.fireUpdate(PROPERTY_TITLE_FONT, oldVal, titleFont);
    }

    public String getTitleFormat() {
        return this._titleFormat;
    }

    public void setTitleFormat(String titleFormat) {
        String oldVal = this._titleFormat;
        this._titleFormat = titleFormat;
        this.fireUpdate(PROPERTY_TITLE_FORMAT, oldVal, titleFormat);
    }

    public Color getTitleColor() {
        return this._titleColor;
    }

    public void setTitleColor(Color titleColor) {
        Color oldVal = this._titleColor;
        this._titleColor = titleColor;
        this.fireUpdate(PROPERTY_TITLE_COLOR, oldVal, titleColor);
    }

    public Font getSubtitleFont() {
        return this._subtitleFont;
    }

    public void setSubtitleFont(Font subtitleFont) {
        Font oldVal = this._subtitleFont;
        this._subtitleFont = subtitleFont;
        this.fireUpdate(PROPERTY_TITLE_FONT, oldVal, subtitleFont);
    }

    public String getSubtitleFormat() {
        return this._subtitleFormat;
    }

    public void setSubtitleFormat(String subtitleFormat) {
        String oldVal = this._subtitleFormat;
        this._subtitleFormat = subtitleFormat;
        this.fireUpdate(PROPERTY_TITLE_FORMAT, oldVal, subtitleFormat);
    }

    public Color getSubtitleColor() {
        return this._subtitleColor;
    }

    public void setSubtitleColor(Color subtitleColor) {
        Color oldVal = this._subtitleColor;
        this._subtitleColor = subtitleColor;
        this.fireUpdate(PROPERTY_TITLE_COLOR, oldVal, subtitleColor);
    }

    public Font getFooterFont() {
        return this._footerFont;
    }

    public void setFooterFont(Font subtitleFont) {
        Font oldVal = this._footerFont;
        this._footerFont = subtitleFont;
        this.fireUpdate(PROPERTY_TITLE_FONT, oldVal, subtitleFont);
    }

    public String getFooterFormat() {
        return this._footerFormat;
    }

    public void setFooterFormat(String subtitleFormat) {
        String oldVal = this._footerFormat;
        this._footerFormat = subtitleFormat;
        this.fireUpdate(PROPERTY_TITLE_FORMAT, oldVal, subtitleFormat);
    }

    public Color getFooterColor() {
        return this._footerColor;
    }

    public void setFooterColor(Color subtitleColor) {
        Color oldVal = this._footerColor;
        this._footerColor = subtitleColor;
        this.fireUpdate(PROPERTY_TITLE_COLOR, oldVal, subtitleColor);
    }

    public boolean isShowThresholds() {
        return this._showThresholds;
    }

    public void setShowThresholds(boolean showThresholds) {
        boolean oldVal = this._showThresholds;
        this._showThresholds = showThresholds;
        this.fireUpdate(PROPERTY_SHOW_THRESHOLDS, oldVal, showThresholds);
    }

    public boolean isShowThresholdText() {
        return this._showThresholdText;
    }

    public void setShowThresholdText(boolean showThresholds) {
        boolean oldVal = this._showThresholdText;
        this._showThresholdText = showThresholds;
        this.fireUpdate(PROPERTY_SHOW_THRESHOLD_VALUES, oldVal, showThresholds);
    }

    public List<Threshold> getThresholds() {
        return this._thresholds;
    }

    public void setThresholds(List<Threshold> thresholds) {
        this._thresholds.clear();
        this._thresholds.addAll(thresholds);
        this.fireUpdate();
    }

    public RoundingTool.RoundingType getRoundingStyle() {
        return this._roundingStyle;
    }

    public void setRoundingStyle(RoundingTool.RoundingType roundingStyle) {
        RoundingTool.RoundingType oldVal = this._roundingStyle;
        this._roundingStyle = roundingStyle;
        this.fireUpdate(PROPERTY_ROUNDING_STYLE, (Object)oldVal, (Object)roundingStyle);
    }

    public int getRoundingPrecision() {
        switch (this._roundingStyle) {
            case DIGITS: {
                return this.getRoundingDigits();
            }
            case DECIMALS: {
                return this.getRoundingDecimals();
            }
            case SIG_FIGS: {
                return this.getRoundingSigFigs();
            }
        }
        return 0;
    }

    public void setRoundingPrecision(int precision) {
        int oldVal;
        switch (this._roundingStyle) {
            case DIGITS: {
                oldVal = this._roundingDigits;
                this._roundingDigits = precision;
                break;
            }
            case DECIMALS: {
                oldVal = this._roundingDecimals;
                this._roundingDecimals = precision;
                break;
            }
            case SIG_FIGS: {
                oldVal = this._roundingSigFigs;
                this._roundingSigFigs = precision;
                break;
            }
            default: {
                oldVal = 0;
            }
        }
        this.fireUpdate(PROPERTY_ROUNDING_PRECISION, oldVal, precision);
    }

    public int getRoundingDigits() {
        return this._roundingDigits;
    }

    public void setRoundingDigits(int roundingDigits) {
        int oldVal = this._roundingDigits;
        this._roundingDigits = roundingDigits;
        this.fireUpdate(PROPERTY_ROUNDING_PRECISION, oldVal, roundingDigits);
    }

    public int getRoundingDecimals() {
        return this._roundingDecimals;
    }

    public void setRoundingDecimals(int roundingDecimals) {
        int oldVal = this._roundingDecimals;
        this._roundingDecimals = roundingDecimals;
        this.fireUpdate(PROPERTY_ROUNDING_PRECISION, oldVal, roundingDecimals);
    }

    public int getRoundingSigFigs() {
        return this._roundingSigFigs;
    }

    public void setRoundingSigFigs(int roundingSigFigs) {
        int oldVal = this._roundingSigFigs;
        this._roundingSigFigs = roundingSigFigs;
        this.fireUpdate(PROPERTY_ROUNDING_PRECISION, oldVal, roundingSigFigs);
    }

    public T getItemControls() {
        return this._itemControls;
    }

    public abstract String toXml();

    public abstract ChartRenderControls<T> fromXml(String var1);

    @Override
    public void fireUpdate(String propertyName, Object oldVal, Object newVal) {
        this._propChangeFirer.firePropertyChange(propertyName, oldVal, newVal);
    }

    @Override
    public void fireUpdate() {
        this.fireUpdate(PROPERTY_UPDATE, false, true);
    }

    public boolean isFooterVisible() {
        return this._footerVisible;
    }

    public void setFooterVisible(boolean _footerVisible) {
        this._footerVisible = _footerVisible;
    }

    public boolean isSubtitleVisible() {
        return this._subtitleVisible;
    }

    public void setSubtitleVisible(boolean _subtitleVisible) {
        this._subtitleVisible = _subtitleVisible;
    }

    public boolean isTitleVisible() {
        return this._titleVisible;
    }

    public void setTitleVisible(boolean _titleVisible) {
        this._titleVisible = _titleVisible;
    }
}

