/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.data;

import hec.gfx2d.swing.charts.data.ChartItemModel;
import hec.gfx2d.swing.charts.data.RmaDataId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChartSnapshotsMap {
    private final Map<Date, List<ChartItemModel>> _snapshots = new HashMap<Date, List<ChartItemModel>>();

    public void put(Date date, ChartItemModel snapshot) {
        List<ChartItemModel> snapshots = this._snapshots.get(date);
        if (snapshots != null) {
            snapshots.add(snapshot);
        } else {
            snapshots = new ArrayList<ChartItemModel>();
            snapshots.add(snapshot);
            this._snapshots.put(date, snapshots);
        }
    }

    public void addAll(ChartSnapshotsMap snapshots) {
        this._snapshots.putAll(snapshots.getAllSnapshots());
    }

    public List<ChartItemModel> get(Date index) {
        return this._snapshots.get(index);
    }

    public Map<Date, List<ChartItemModel>> getAllSnapshots() {
        return this._snapshots;
    }

    public ChartItemModel find(RmaDataId id, Date indexDate) {
        ChartItemModel retVal = null;
        for (ChartItemModel snapshot : this._snapshots.get(indexDate)) {
            if (!snapshot.getId().equals(id)) continue;
            retVal = snapshot;
            break;
        }
        return retVal;
    }

    public Set<RmaDataId> idSet() {
        LinkedHashSet<RmaDataId> retVal = new LinkedHashSet<RmaDataId>();
        for (Date index : this._snapshots.keySet()) {
            for (ChartItemModel snapshot : this._snapshots.get(index)) {
                retVal.add(snapshot.getId());
            }
        }
        return retVal;
    }

    public Set<Date> dateSet() {
        return this._snapshots.keySet();
    }
}

