/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.data;

import hec.gfx2d.swing.charts.data.ChartModel;
import hec.gfx2d.swing.charts.data.ChartSnapshotsMap;
import hec.gfx2d.swing.charts.data.RmaDataId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public final class DefaultChartModel
implements ChartModel {
    private final RmaDataId _id;
    private final ChartSnapshotsMap _snapshots;
    private Comparator<RmaDataId> _idComparator;

    public DefaultChartModel(RmaDataId id, ChartSnapshotsMap snapshots) {
        this._id = id;
        this._snapshots = snapshots;
        this._idComparator = (id1, id2) -> {
            int retVal = id1 == null && id2 == null ? 0 : (id1 == null ? 1 : (id2 == null ? -1 : id1.compareTo((RmaDataId)id2)));
            return retVal;
        };
    }

    @Override
    public RmaDataId getId() {
        return this._id;
    }

    @Override
    public double getValue(RmaDataId itemId, Date timeIndex) {
        return this._snapshots.find(itemId, this.getClosestDate(timeIndex)).getValue();
    }

    @Override
    public double getMinValue(RmaDataId itemId, Date timeIndex) {
        return this._snapshots.find(itemId, this.getClosestDate(timeIndex)).getMinValue();
    }

    @Override
    public double getMaxValue(RmaDataId itemId, Date timeIndex) {
        return this._snapshots.find(itemId, this.getClosestDate(timeIndex)).getMaxValue();
    }

    @Override
    public int getQuality(RmaDataId itemId, Date timeIndex) {
        return this._snapshots.find(itemId, this.getClosestDate(timeIndex)).getQuality();
    }

    @Override
    public String getUnits(RmaDataId itemId) {
        return this._snapshots.find(itemId, this.getEarliestDate()).getUnits();
    }

    @Override
    public Date getEarliestDate() {
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.addAll(this._snapshots.dateSet());
        if (dates.isEmpty()) {
            return new Date(0L);
        }
        Date retDate = (Date)dates.get(0);
        for (Date date : dates) {
            if (!date.before(retDate)) continue;
            retDate = date;
        }
        return retDate;
    }

    @Override
    public Date getLatestDate() {
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.addAll(this._snapshots.dateSet());
        if (dates.isEmpty()) {
            return new Date(0L);
        }
        Date retDate = (Date)dates.get(0);
        for (Date date : dates) {
            if (!date.after(retDate)) continue;
            retDate = date;
        }
        return retDate;
    }

    @Override
    public Date getClosestDate(Date date) {
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.addAll(this._snapshots.dateSet());
        if (dates.isEmpty()) {
            return new Date(0L);
        }
        Date retDate = (Date)dates.get(0);
        for (Date d : dates) {
            if (Math.abs(date.getTime() - d.getTime()) >= Math.abs(date.getTime() - retDate.getTime())) continue;
            retDate = d;
        }
        return retDate;
    }

    @Override
    public void setComparator(Comparator<RmaDataId> idComparator) {
        this._idComparator = idComparator;
    }

    @Override
    public List<RmaDataId> getItemIds() {
        ArrayList<RmaDataId> retList = new ArrayList<RmaDataId>();
        retList.addAll(this._snapshots.idSet());
        retList.sort(this._idComparator);
        return retList;
    }
}

