/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.options;

import hec.gfx2d.swing.charts.pie.PieChartRenderControls;
import hec.gfx2d.swing.charts.util.AngleOption;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;

public class AngleOptionsPanel
extends JPanel {
    private JComboBox<AngleOption> _angleOptionsBox;
    private RmaJDecimalField _startAngleField;
    private RmaJCheckBox _drawClockwiseBox;
    private boolean _startAngleInDegrees = true;
    private static final String DEGREE_BORDER = "Start Angle In Degrees (0 - 360)";
    private static final String RADIAN_BORDER = "Start Angle In Radians (0 - 2\u03c0)";

    public AngleOptionsPanel() {
        this.buildComponents();
        this.addListeners();
    }

    public void load(PieChartRenderControls controls) {
        this._angleOptionsBox.setSelectedItem((Object)controls.getStartAngleMeasure());
        this._startAngleField.setValue(controls.getStartAngle());
        this._startAngleField.setMinValue(0.0);
        this._drawClockwiseBox.setSelected(controls.isDrawClockwise());
        String borderStr = "";
        switch (controls.getStartAngleMeasure()) {
            case RADIANS: {
                borderStr = RADIAN_BORDER;
                this._startAngleField.setMaxValue(Math.PI * 2);
                break;
            }
            case DEGREES: {
                borderStr = DEGREE_BORDER;
                this._startAngleField.setMaxValue(360.0);
            }
        }
        this.setBorder(BorderFactory.createTitledBorder(borderStr));
    }

    public void save(PieChartRenderControls controls) {
        controls.setStartAngleMeasure(this._angleOptionsBox.getItemAt(this._angleOptionsBox.getSelectedIndex()));
        controls.setStartAngle(this._startAngleField.getValue());
        controls.setDrawClockwise(this._drawClockwiseBox.isSelected());
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(DEGREE_BORDER));
        this._drawClockwiseBox = new RmaJCheckBox();
        this._drawClockwiseBox.setText("Draw Clockwise");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this._drawClockwiseBox, gbc);
        this._angleOptionsBox = new JComboBox<AngleOption>(AngleOption.values());
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add(this._angleOptionsBox, gbc);
        this._startAngleField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._startAngleField, gbc);
    }

    private void addListeners() {
        this._angleOptionsBox.addActionListener(e -> {
            switch (this._angleOptionsBox.getItemAt(this._angleOptionsBox.getSelectedIndex())) {
                case DEGREES: {
                    this.handleDegreesSelected();
                    break;
                }
                case RADIANS: {
                    this.handleRadiansSelected();
                }
            }
        });
    }

    private void handleDegreesSelected() {
        this.setBorder(BorderFactory.createTitledBorder(DEGREE_BORDER));
        this._startAngleField.setMaxValue(360.0);
        if (!this._startAngleInDegrees) {
            this._startAngleField.setValue(Math.toDegrees(this._startAngleField.getValue()));
            this._startAngleInDegrees = true;
        }
    }

    private void handleRadiansSelected() {
        this.setBorder(BorderFactory.createTitledBorder(RADIAN_BORDER));
        this._startAngleField.setMaxValue(Math.PI * 2);
        if (this._startAngleInDegrees) {
            this._startAngleField.setValue(Math.toRadians(this._startAngleField.getValue()));
            this._startAngleInDegrees = false;
        }
    }
}

