/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.options;

import hec.gfx2d.swing.charts.color.ColorContourOptionsPanel;
import hec.gfx2d.swing.charts.options.TextOptionsPanel;
import hec.gfx2d.swing.charts.pie.PieSliceRenderControls;
import hec.gfx2d.swing.charts.thresholds.ThresholdOptionsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;

public class EditPieSlicePanel
extends JPanel {
    private RmaJCheckBox _visibleBox;
    private RmaJCheckBox _showValueBox;
    private RmaJCheckBox _singleColorBox;
    private ColorContourOptionsPanel _colorOptionsPanel;
    private RmaJCheckBox _showLabelBox;
    private TextOptionsPanel _labelPanel;
    private ThresholdOptionsPanel _thresholdOptionsPanel;
    private static final String GENERAL_TAB = "General";
    private static final String TITLE_TAB = "Label";
    private static final String THRESHOLD_TAB = "Thresholds";

    public EditPieSlicePanel() {
        this.buildComponents();
        this.addListeners();
    }

    public void load(PieSliceRenderControls controls) {
        if (controls != null) {
            this._visibleBox.setSelected(controls.isVisible());
            this._showValueBox.setSelected(controls.isShowValue());
            this._showValueBox.setEnabled(this._visibleBox.isSelected());
            this._singleColorBox.setSelected(controls.isSingleColor());
            this._colorOptionsPanel.loadContour(controls.getContour(), controls.getContourType());
            this._showLabelBox.setSelected(controls.isShowLabel());
            this._showLabelBox.setEnabled(this._visibleBox.isSelected());
            this._labelPanel.setObjectText(controls.getLabelFormat());
            this._labelPanel.setObjectFont(controls.getLabelFont());
            this._labelPanel.setObjectColor(controls.getLabelColor());
            this._labelPanel.setEnabled(this._visibleBox.isSelected() && this._showLabelBox.isSelected());
            this._thresholdOptionsPanel.setShowThresholds(controls.isShowThresholds());
            this._thresholdOptionsPanel.load(controls.getThresholds());
            this._thresholdOptionsPanel.setEnabled(this._visibleBox.isSelected() && this._thresholdOptionsPanel.isShowThresholds());
        }
    }

    public PieSliceRenderControls save() {
        PieSliceRenderControls retControls = new PieSliceRenderControls();
        retControls.setVisible(this._visibleBox.isSelected());
        retControls.setShowValue(this._showValueBox.isSelected());
        retControls.setSingleColor(this._singleColorBox.isSelected());
        retControls.setContour(this._colorOptionsPanel.saveContour());
        retControls.setContourType(this._colorOptionsPanel.getContourType());
        retControls.setShowLabel(this._showLabelBox.isSelected());
        retControls.setLabelFormat(this._labelPanel.getObjectText());
        retControls.setLabelFont(this._labelPanel.getObjectFont());
        retControls.setLabelColor(this._labelPanel.getObjectColor());
        retControls.setShowThresholds(this._thresholdOptionsPanel.isShowThresholds());
        retControls.setThresholds(this._thresholdOptionsPanel.save());
        return retControls;
    }

    private void buildComponents() {
        JPanel generalTab = new JPanel();
        generalTab.setLayout(new GridBagLayout());
        this._visibleBox = new RmaJCheckBox();
        this._visibleBox.setText("Show Item");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        generalTab.add((Component)this._visibleBox, gbc);
        this._showValueBox = new RmaJCheckBox();
        this._showValueBox.setText("Show Exact Value");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        generalTab.add((Component)this._showValueBox, gbc);
        this._singleColorBox = new RmaJCheckBox();
        this._singleColorBox.setText("Single Color");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        generalTab.add((Component)this._singleColorBox, gbc);
        this._colorOptionsPanel = new ColorContourOptionsPanel();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.INSETS5505;
        generalTab.add((Component)this._colorOptionsPanel, gbc);
        JPanel titleTab = new JPanel();
        titleTab.setLayout(new GridBagLayout());
        this._showLabelBox = new RmaJCheckBox();
        this._showLabelBox.setText("Show Label");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        titleTab.add((Component)this._showLabelBox, gbc);
        this._labelPanel = new TextOptionsPanel();
        this._labelPanel.setObjectTitle(TITLE_TAB);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        titleTab.add((Component)this._labelPanel, gbc);
        JPanel thresholdTab = new JPanel();
        thresholdTab.setLayout(new GridBagLayout());
        this._thresholdOptionsPanel = new ThresholdOptionsPanel();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5555;
        thresholdTab.add((Component)this._thresholdOptionsPanel, gbc);
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab(GENERAL_TAB, generalTab);
        tabs.addTab(TITLE_TAB, titleTab);
        tabs.addTab(THRESHOLD_TAB, thresholdTab);
        this.add(tabs);
    }

    private void addListeners() {
        this._visibleBox.addActionListener(e -> {
            this._showLabelBox.setEnabled(this._visibleBox.isSelected());
            this._singleColorBox.setEnabled(this._visibleBox.isSelected());
            this._labelPanel.setEnabled(this._visibleBox.isSelected() && this._showLabelBox.isSelected());
            this._showValueBox.setEnabled(this._visibleBox.isSelected());
            this._thresholdOptionsPanel.setEnabled(this._visibleBox.isSelected() && this._thresholdOptionsPanel.isShowThresholds());
        });
        this._showLabelBox.addActionListener(e -> this._labelPanel.setEnabled(this._visibleBox.isSelected() && this._showLabelBox.isSelected()));
    }
}

