/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.options;

import hec.gfx2d.swing.charts.color.ColorContourOptionsPanel;
import hec.gfx2d.swing.charts.options.AngleOptionsPanel;
import hec.gfx2d.swing.charts.options.RoundingOptionsPanel;
import hec.gfx2d.swing.charts.pie.PieChartRenderControls;
import hec.gfx2d.swing.charts.util.LegendSide;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;

public class PieChartOptionsGeneralPanel
extends JPanel {
    private JCheckBox _showLegendBox;
    private RmaJComboBox<LegendSide> _legendSideBox;
    private AngleOptionsPanel _startAnglePanel;
    private JCheckBox _showRadialSumBox;
    private JCheckBox _singleColorSumBox;
    private ColorContourOptionsPanel _colorOptionsPanel;
    private RoundingOptionsPanel _roundingPanel;

    public PieChartOptionsGeneralPanel() {
        this.buildComponents();
        this.addListeners();
    }

    public void load(PieChartRenderControls controls) {
        this._showLegendBox.setSelected(controls.isShowLegend());
        this._legendSideBox.setSelectedItem((Object)controls.getLegendSide());
        this._legendSideBox.setEnabled(this._showLegendBox.isSelected());
        this._showRadialSumBox.setSelected(controls.isShowRadialSum());
        this._singleColorSumBox.setSelected(controls.isSingleColorSum());
        this._singleColorSumBox.setEnabled(this._showRadialSumBox.isSelected());
        this._colorOptionsPanel.loadContour(controls.getRadialSumContour(), controls.getRadialSumContourType());
        this._colorOptionsPanel.setEnabled(this._showRadialSumBox.isSelected());
        this._startAnglePanel.load(controls);
        this._roundingPanel.load(controls);
    }

    public void save(PieChartRenderControls controls) {
        controls.setShowLegend(this._showLegendBox.isSelected());
        controls.setLegendSide((LegendSide)((Object)this._legendSideBox.getItemAt(this._legendSideBox.getSelectedIndex())));
        controls.setShowRadialSum(this._showRadialSumBox.isSelected());
        controls.setSingleColorSum(this._singleColorSumBox.isSelected());
        controls.setRadialSumContour(this._colorOptionsPanel.saveContour());
        controls.setRadialSumContourType(this._colorOptionsPanel.getContourType());
        this._startAnglePanel.save(controls);
        this._roundingPanel.save(controls);
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        JPanel legendPanel = this.buildLegendOptionsPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)legendPanel, gbc);
        this._roundingPanel = new RoundingOptionsPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this._roundingPanel, gbc);
        this._startAnglePanel = new AngleOptionsPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this._startAnglePanel, gbc);
        this._showRadialSumBox = new JCheckBox();
        this._showRadialSumBox.setText("Show Radial Sum");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this._showRadialSumBox, gbc);
        this._singleColorSumBox = new JCheckBox();
        this._singleColorSumBox.setText("Single Color");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this._singleColorSumBox, gbc);
        this._colorOptionsPanel = new ColorContourOptionsPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._colorOptionsPanel, gbc);
    }

    private JPanel buildLegendOptionsPanel() {
        JPanel legendSidePanel = new JPanel();
        legendSidePanel.setLayout(new GridBagLayout());
        legendSidePanel.setBorder(BorderFactory.createTitledBorder("Legend Options"));
        this._showLegendBox = new JCheckBox();
        this._showLegendBox.setText("Show Legend");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        legendSidePanel.add((Component)this._showLegendBox, gbc);
        this._legendSideBox = new RmaJComboBox<LegendSide>(LegendSide.values());
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        legendSidePanel.add(this._legendSideBox, gbc);
        return legendSidePanel;
    }

    private void addListeners() {
        this._showLegendBox.addActionListener(e -> this._legendSideBox.setEnabled(this._showLegendBox.isSelected()));
        this._showRadialSumBox.addActionListener(e -> {
            this._singleColorSumBox.setEnabled(this._showRadialSumBox.isSelected());
            this._colorOptionsPanel.setEnabled(this._showRadialSumBox.isSelected());
        });
    }
}

