/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.options;

import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.gfx2d.swing.charts.options.EditPieSlicePanel;
import hec.gfx2d.swing.charts.options.PieChartOptionsGeneralPanel;
import hec.gfx2d.swing.charts.options.PieChartOptionsTitlePanel;
import hec.gfx2d.swing.charts.pie.PieChartRenderControls;
import hec.gfx2d.swing.charts.pie.PieSliceRenderControls;
import hec.gfx2d.swing.charts.thresholds.ThresholdOptionsPanel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PieChartOptionsPanel
extends JPanel {
    private PieChartOptionsGeneralPanel _generalOptionsPanel;
    private PieChartOptionsTitlePanel _titleOptionsPanel;
    private ThresholdOptionsPanel _thresholdOptionsPanel;
    private EditPieSlicePanel _sliceOptionsPanel;
    private static final String GENERAL_TAB = "General";
    private static final String TITLE_TAB = "Titles";
    private static final String THRESHOLD_TAB = "Thresholds";
    private static final String SLICE_TAB = "Slices";

    public PieChartOptionsPanel() {
        this.buildComponents();
        this.addListeners();
    }

    public void load(PieChartRenderControls controls) {
        if (controls != null) {
            this._generalOptionsPanel.load(controls);
            this._titleOptionsPanel.load(controls);
            this._thresholdOptionsPanel.setShowThresholds(controls.isShowThresholds());
            this._thresholdOptionsPanel.load(controls.getThresholds());
            this._sliceOptionsPanel.load((PieSliceRenderControls)controls.getItemControls());
        }
    }

    public PieChartRenderControls save(RmaDataId controlId) {
        PieChartRenderControls controls = new PieChartRenderControls(controlId);
        this._generalOptionsPanel.save(controls);
        this._titleOptionsPanel.save(controls);
        controls.setShowThresholds(this._thresholdOptionsPanel.isShowThresholds());
        controls.setThresholds(this._thresholdOptionsPanel.save());
        controls.setItemControls(this._sliceOptionsPanel.save());
        return controls;
    }

    private void buildComponents() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this._generalOptionsPanel = new PieChartOptionsGeneralPanel();
        this._titleOptionsPanel = new PieChartOptionsTitlePanel();
        this._thresholdOptionsPanel = new ThresholdOptionsPanel();
        this._sliceOptionsPanel = new EditPieSlicePanel();
        tabbedPane.addTab(GENERAL_TAB, this._generalOptionsPanel);
        tabbedPane.addTab(TITLE_TAB, this._titleOptionsPanel);
        tabbedPane.addTab(THRESHOLD_TAB, this._thresholdOptionsPanel);
        tabbedPane.addTab(SLICE_TAB, this._sliceOptionsPanel);
        this.add(tabbedPane);
    }

    private void addListeners() {
    }
}

