/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.options;

import hec.gfx2d.swing.charts.pie.PieChartRenderControls;
import hec.gfx2d.swing.charts.util.RoundingTool;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJIntegerField;

public class RoundingOptionsPanel
extends JPanel {
    private JComboBox<RoundingTool.RoundingType> _roundingTypeBox;
    private RmaJIntegerField _roundingPrecisionField;
    private RoundingTool.RoundingType _roundingType = RoundingTool.RoundingType.DECIMALS;
    private int _decimals = 1;
    private int _digits = 1;
    private int _sigFigs = 1;

    public RoundingOptionsPanel() {
        this.buildComponents();
        this.addListeners();
    }

    public void load(PieChartRenderControls controls) {
        this._roundingType = controls.getRoundingStyle();
        this._decimals = controls.getRoundingDecimals();
        this._digits = controls.getRoundingDigits();
        this._sigFigs = controls.getRoundingSigFigs();
        this._roundingTypeBox.setSelectedItem((Object)this._roundingType);
        this._roundingPrecisionField.setValue(controls.getRoundingPrecision());
    }

    public void save(PieChartRenderControls controls) {
        controls.setRoundingStyle(this._roundingType);
        controls.setRoundingDecimals(this._decimals);
        controls.setRoundingDigits(this._digits);
        controls.setRoundingSigFigs(this._sigFigs);
        controls.setRoundingPrecision(this._roundingPrecisionField.getValue());
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Rounding Precision"));
        this._roundingTypeBox = new JComboBox<RoundingTool.RoundingType>(RoundingTool.RoundingType.values());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add(this._roundingTypeBox, gbc);
        this._roundingPrecisionField = new RmaJIntegerField();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._roundingPrecisionField, gbc);
    }

    private void addListeners() {
        this._roundingTypeBox.addActionListener(e -> {
            this.updateAppropriateValue(this._roundingPrecisionField.getValue());
            switch (this._roundingTypeBox.getItemAt(this._roundingTypeBox.getSelectedIndex())) {
                case DECIMALS: {
                    this._roundingPrecisionField.setValue(this._decimals);
                    break;
                }
                case DIGITS: {
                    this._roundingPrecisionField.setValue(this._digits);
                    break;
                }
                case SIG_FIGS: {
                    this._roundingPrecisionField.setValue(this._sigFigs);
                }
            }
            this._roundingType = this._roundingTypeBox.getItemAt(this._roundingTypeBox.getSelectedIndex());
        });
    }

    private void updateAppropriateValue(int newValue) {
        switch (this._roundingType) {
            case DECIMALS: {
                this._decimals = newValue;
                break;
            }
            case DIGITS: {
                this._digits = newValue;
                break;
            }
            case SIG_FIGS: {
                this._sigFigs = newValue;
            }
        }
    }
}

