/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import rma.swing.FontChooserPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorChooserButton;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;

public class TextOptionsPanel
extends RmaJPanel {
    private String _title;
    private RmaJTextField _textField;
    private FontChooserPanel _fontChooserPanel;
    private RmaJColorChooserButton _colorButton;

    public TextOptionsPanel() {
        this.buildComponents();
        this.addListeners();
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        RmaJLabel formatLabel = new RmaJLabel();
        formatLabel.setText("Format:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 13;
        this.add((Component)formatLabel, gbc);
        this._textField = new RmaJTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 17;
        this.add((Component)this._textField, gbc);
        this._colorButton = new RmaJColorChooserButton();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 17;
        this.add((Component)this._colorButton, gbc);
        this._fontChooserPanel = new FontChooserPanel(new Font("Serif", 0, 12));
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.anchor = 17;
        this.add((Component)this._fontChooserPanel, gbc);
    }

    private void addListeners() {
        this._colorButton.addSampleListener(evt -> {
            if (evt.getPropertyName().equals("RmaJColorChooserButton.Property.Color")) {
                this._fontChooserPanel.setFontColor((Color)evt.getNewValue());
            }
        });
    }

    public void setObjectTitle(String title) {
        this._title = title;
        this.setBorder(BorderFactory.createTitledBorder(this._title));
    }

    public String getObjectTitle() {
        return this._title;
    }

    public void setObjectText(String text) {
        this._textField.setText(text);
    }

    public String getObjectText() {
        return this._textField.getText();
    }

    public void setObjectFont(Font font) {
        this._fontChooserPanel.setSelectedFont(font);
    }

    public Font getObjectFont() {
        return this._fontChooserPanel.getSelectedFont();
    }

    public void setObjectColor(Color color) {
        this._colorButton.setColor(color);
        this._fontChooserPanel.setFontColor(color);
    }

    public Color getObjectColor() {
        return this._colorButton.getColor();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._textField.setEnabled(enabled);
        this._colorButton.setEnabled(enabled);
        this._fontChooserPanel.setEnabled(enabled);
    }
}

