/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.pie;

import hec.gfx2d.swing.charts.color.ColorContourType;
import hec.gfx2d.swing.charts.data.ChartModel;
import hec.gfx2d.swing.charts.data.ChartSnapshotsMap;
import hec.gfx2d.swing.charts.data.DefaultChartItemModel;
import hec.gfx2d.swing.charts.data.DefaultChartModel;
import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.gfx2d.swing.charts.options.PieChartOptionsPanel;
import hec.gfx2d.swing.charts.pie.PieChartRenderControls;
import hec.gfx2d.swing.charts.pie.PieChartView;
import hec.gfx2d.swing.charts.pie.PieLegendView;
import hec.gfx2d.swing.charts.pie.PieSliceRenderControls;
import hec.gfx2d.swing.charts.pie.PieSliceView;
import hec.gfx2d.swing.charts.thresholds.Threshold;
import hec.gfx2d.swing.charts.util.AngleOption;
import hec.gfx2d.swing.charts.util.LegendSide;
import hec.gfx2d.swing.charts.util.Roundable;
import hec.gfx2d.swing.charts.util.RoundingTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import rma.swing.RmaInsets;
import rma.util.BandedColorContour;
import rma.util.contour.ColorContourRecord;

public class PieChartPanel
extends JPanel
implements PropertyChangeListener,
Roundable {
    private final ChartModel _model;
    private final PieChartRenderControls _controls;
    private final PieChartView _chartView;
    private final PieLegendView _legendView;
    private final List<PieSliceView> _slices = new ArrayList<PieSliceView>();
    private Date _currentTime;
    private static final String COMMAND_ESCAPE = "VK_ESCAPE";
    private static final String COMMAND_UP = "VK_UP";
    private static final String COMMAND_DOWN = "VK_DOWN";
    private static final String COMMAND_LEFT = "VK_LEFT";
    private static final String COMMAND_RIGHT = "VK_RIGHT";
    private static final String NAME_FORMAT = "<%Name%>";
    private static final String LOCATION_FORMAT = "<%Location%>";
    private static final String DESCRIPTION_FORMAT = "<%Description%>";
    private static final String DATE_FORMAT = "<%Date%>";
    private static final String PORTION_FORMAT = "<%Portion%>";
    private static final String FILL_FORMAT = "<%Fill%>";
    private static final String VALUE_FORMAT = "<%Value%>";
    private static final String MIN_VALUE_FORMAT = "<%MinValue%>";
    private static final String MAX_VALUE_FORMAT = "<%MaxValue%>";
    private static final String RELATIVE_VALUE_FORMAT = "<%RelativeValue%>";
    private static final String RELATIVE_MAX_FORMAT = "<%RelativeMax%>";
    private static final String QUALITY_FORMAT = "<%Quality%>";
    private static final String UNITS_FORMAT = "<%Units%>";

    public PieChartPanel(ChartModel model, PieChartRenderControls controls) {
        this._model = model;
        this._controls = controls;
        this._chartView = new PieChartView(this);
        this._legendView = new PieLegendView(this);
        this._currentTime = this._model.getEarliestDate();
        this.buildSlices();
        this.buildComponents();
        this.addListeners();
    }

    public final ChartModel getModel() {
        return this._model;
    }

    private void buildSlices() {
        List slices = this._model.getItemIds().stream().map(PieSliceView::new).collect(Collectors.toList());
        this._slices.addAll(slices);
    }

    public void setTime(Date date) {
        this._currentTime = date;
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 4.0;
        gbc.weighty = 4.0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.fill = 1;
        this.add((Component)this._chartView, gbc);
        this.add(this._legendView);
        this.updateLegend();
        this.setVisible(true);
    }

    private void addListeners() {
        PropertyChangeListener listener = evt -> {
            this.updateLegend();
            this.update();
        };
        this._controls.addListener(listener);
        this._chartView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 1) {
                    for (RmaDataId sliceId : PieChartPanel.this._model.getItemIds()) {
                        if (!PieChartPanel.this._chartView.getSlice(sliceId).contains(e.getPoint())) continue;
                        PieChartPanel.this._chartView.setSelectedSlice(sliceId);
                        PieChartPanel.this._legendView.setSelectedItem(sliceId);
                        PieChartPanel.this.update();
                        break;
                    }
                }
            }
        });
        this._legendView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 1) {
                    for (RmaDataId sliceId : PieChartPanel.this._model.getItemIds()) {
                        if (!PieChartPanel.this._legendView.getItem(sliceId).contains(e.getPoint())) continue;
                        PieChartPanel.this._chartView.setSelectedSlice(sliceId);
                        PieChartPanel.this._legendView.setSelectedItem(sliceId);
                        PieChartPanel.this.update();
                        break;
                    }
                }
            }
        });
        this.setupKeyBindings();
    }

    public PieChartView getChartView() {
        return this._chartView;
    }

    private void setupKeyBindings() {
        ActionMap actionMap = this.getActionMap();
        InputMap keyMap = this.getInputMap(2);
        keyMap.put(KeyStroke.getKeyStroke(27, 0), COMMAND_ESCAPE);
        keyMap.put(KeyStroke.getKeyStroke(38, 0), COMMAND_UP);
        keyMap.put(KeyStroke.getKeyStroke(40, 0), COMMAND_DOWN);
        keyMap.put(KeyStroke.getKeyStroke(37, 0), COMMAND_LEFT);
        keyMap.put(KeyStroke.getKeyStroke(39, 0), COMMAND_RIGHT);
        actionMap.put(COMMAND_ESCAPE, new KeyAction(COMMAND_ESCAPE));
        actionMap.put(COMMAND_UP, new KeyAction(COMMAND_UP));
        actionMap.put(COMMAND_DOWN, new KeyAction(COMMAND_DOWN));
        actionMap.put(COMMAND_LEFT, new KeyAction(COMMAND_LEFT));
        actionMap.put(COMMAND_RIGHT, new KeyAction(COMMAND_RIGHT));
    }

    private void updateLegend() {
        this.remove(this._legendView);
        if (this._controls.isShowLegend()) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 10;
            gbc.fill = 1;
            gbc.insets = RmaInsets.INSETS5505;
            switch (this._controls.getLegendSide()) {
                case LEFT: {
                    gbc.gridx = 0;
                    gbc.gridy = 1;
                    gbc.weightx = 1.0;
                    break;
                }
                case RIGHT: {
                    gbc.gridx = 2;
                    gbc.gridy = 1;
                    gbc.weightx = 1.0;
                    break;
                }
                case TOP: {
                    gbc.gridx = 1;
                    gbc.gridy = 0;
                    gbc.weighty = 1.0;
                    break;
                }
                case BOTTOM: {
                    gbc.gridx = 1;
                    gbc.gridy = 3;
                    gbc.weighty = 1.0;
                }
            }
            this.add((Component)this._legendView, gbc);
        }
        this.update();
    }

    private void handleKeyEscape() {
        this._chartView.clearSelectedSlice();
        this._legendView.clearSelectedItem();
        this.update();
    }

    private void handleKeyUp() {
        this._chartView.handleKeyUp();
        this._legendView.handleKeyUp();
        this.update();
    }

    private void handleKeyDown() {
        this._chartView.handleKeyDown();
        this._legendView.handleKeyDown();
        this.update();
    }

    private void openOptionsMenu() {
        PieChartOptionsPanel optionsPanel = new PieChartOptionsPanel();
        optionsPanel.load(this._controls);
        int confirmResult = JOptionPane.showConfirmDialog(this, optionsPanel, "Modify Chart Properties", 2, -1);
        if (confirmResult == 0) {
            PieChartRenderControls newControls = optionsPanel.save(this._controls.getId());
            this._controls.copy(newControls);
            this._controls.fireUpdate();
        }
    }

    public void updateCurrentTime(Date trialTime) {
        this._currentTime = this._model.getClosestDate(trialTime);
        this.update();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this._chartView.revalidate();
        this._chartView.repaint();
        this._legendView.revalidate();
        this._legendView.repaint();
        this.revalidate();
        this.repaint();
    }

    private void update() {
        this.propertyChange(new PropertyChangeEvent(this, "rmaChartRenderControls.update", 0, 1));
    }

    public final List<PieSliceView> getSlices() {
        return this._slices;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setLayout(new GridBagLayout());
        RmaDataId modelId = new RmaDataId("Test", "Test Location", "Test Description");
        ChartSnapshotsMap snapshots = new ChartSnapshotsMap();
        String units = "units";
        for (int i = 0; i < 20; ++i) {
            RmaDataId itemId = new RmaDataId("Item " + (i + 1), "Test Location", "Test Description");
            int quality = 0;
            double value = (double)i * 10.0;
            double minValue = (double)i * 2.0;
            double maxValue = 100.0;
            DefaultChartItemModel model = new DefaultChartItemModel(itemId, value, minValue, maxValue, quality, units);
            snapshots.put(new Date(0L), model);
        }
        DefaultChartModel chartModel = new DefaultChartModel(modelId, snapshots);
        chartModel.setComparator((id1, id2) -> 0);
        PieChartRenderControls chartControls = new PieChartRenderControls(chartModel.getId(), new PieSliceRenderControls());
        PieChartPanel panel = new PieChartPanel(chartModel, chartControls);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        frame.add((Component)panel, gbc);
        frame.setSize(1200, 800);
        frame.setVisible(true);
    }

    public double getTotalValue() {
        double retVal = 0.0;
        for (RmaDataId sliceId : this.getSliceIds()) {
            if (!this.isSliceVisible(sliceId)) continue;
            retVal += this._model.getValue(sliceId, this._currentTime);
        }
        return retVal;
    }

    public double getTotalRelativeValue() {
        double absoluteValue = this.getTotalValue();
        double absoluteMin = this.getTotalMinValue();
        return absoluteValue - absoluteMin;
    }

    public double getSliceValue(RmaDataId sliceId) {
        return this._model.getValue(sliceId, this._currentTime);
    }

    public double getSliceRelativeValue(RmaDataId sliceId) {
        double absoluteValue = this.getSliceValue(sliceId);
        double absoluteMin = this.getSliceMinValue(sliceId);
        return absoluteValue - absoluteMin;
    }

    public double getTotalMinValue() {
        double retVal = 0.0;
        for (RmaDataId sliceId : this.getSliceIds()) {
            if (!this.isSliceVisible(sliceId)) continue;
            retVal += this._model.getMinValue(sliceId, this._currentTime);
        }
        return retVal;
    }

    public double getSliceMinValue(RmaDataId sliceId) {
        return this._model.getMinValue(sliceId, this._currentTime);
    }

    public double getTotalMaxValue() {
        double retVal = 0.0;
        for (RmaDataId sliceId : this.getSliceIds()) {
            if (!this.isSliceVisible(sliceId)) continue;
            retVal += this._model.getMaxValue(sliceId, this._currentTime);
        }
        return retVal;
    }

    public double getTotalRelativeMax() {
        double absoluteMax = this.getTotalMaxValue();
        double absoluteMin = this.getTotalMinValue();
        return absoluteMax - absoluteMin;
    }

    public double getSliceMaxValue(RmaDataId sliceId) {
        return this._model.getMaxValue(sliceId, this._currentTime);
    }

    public double getSliceRelativeMax(RmaDataId sliceId) {
        double absoluteMax = this.getSliceMaxValue(sliceId);
        double absoluteMin = this.getSliceMinValue(sliceId);
        return absoluteMax - absoluteMin;
    }

    public double getQuality() {
        double retVal = 0.0;
        double numSlices = 0.0;
        for (RmaDataId sliceId : this.getSliceIds()) {
            if (!this.isSliceVisible(sliceId)) continue;
            retVal += (double)this._model.getQuality(sliceId, this._currentTime);
            numSlices += 1.0;
        }
        return retVal / numSlices;
    }

    public int getSliceQuality(RmaDataId sliceId) {
        return this._model.getQuality(sliceId, this._currentTime);
    }

    public String getUnits() {
        return this._model.getUnits(this.getSliceIds().get(0));
    }

    public String getSliceUnits(RmaDataId sliceId) {
        return this._model.getUnits(sliceId);
    }

    public List<RmaDataId> getSliceIds() {
        return this._model.getItemIds();
    }

    public LegendSide getLegendSide() {
        return this._controls.getLegendSide();
    }

    public Font getTitleFont() {
        return this._controls.getTitleFont();
    }

    public String getTitleFormat() {
        return this.replaceAttributeFormat(this._controls.getTitleFormat(), FormatContext.CHART, null);
    }

    public Color getTitleColor() {
        return this._controls.getTitleColor();
    }

    public Font getSubtitleFont() {
        return this._controls.getSubtitleFont();
    }

    public String getSubtitleFormat() {
        return this.replaceAttributeFormat(this._controls.getSubtitleFormat(), FormatContext.CHART, null);
    }

    public Color getSubtitleColor() {
        return this._controls.getSubtitleColor();
    }

    public Font getFooterFont() {
        return this._controls.getFooterFont();
    }

    public String getFooterFormat() {
        return this.replaceAttributeFormat(this._controls.getFooterFormat(), FormatContext.CHART, null);
    }

    public Color getFooterColor() {
        return this._controls.getFooterColor();
    }

    public boolean isShowRadialSum() {
        return this._controls.isShowRadialSum();
    }

    public boolean isSingleColorSum() {
        return this._controls.isSingleColorSum();
    }

    public ColorContourRecord getRadialSumContour() {
        return this._controls.getRadialSumContour();
    }

    public ColorContourType getRadialSumContourType() {
        return this._controls.getRadialSumContourType();
    }

    public int getBandedContourMax(BandedColorContour contour) {
        return ((Double)contour.getIndexes().first()).intValue();
    }

    public int getBandedContourMin(BandedColorContour contour) {
        return ((Double)contour.getIndexes().last()).intValue();
    }

    public boolean isDrawClockwise() {
        return this._controls.isDrawClockwise();
    }

    public double getStartAngle() {
        return this._controls.getStartAngle();
    }

    public AngleOption getStartAngleMeasure() {
        return this._controls.getStartAngleMeasure();
    }

    public boolean isShowThresholds() {
        return this._controls.isShowThresholds();
    }

    public boolean isShowThresholdText() {
        return this._controls.isShowThresholdText();
    }

    public List<Threshold> getThresholds() {
        return this._controls.getThresholds();
    }

    @Override
    public double round(double toRound) {
        return RoundingTool.round(toRound, this._controls.getRoundingStyle(), this._controls.getRoundingPrecision());
    }

    public boolean isSliceVisible(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).isVisible();
    }

    public boolean isSliceSingleColor(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).isSingleColor();
    }

    public ColorContourRecord getSliceContour(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).getContour();
    }

    public ColorContourType getSliceContourType(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).getContourType();
    }

    public boolean isSliceShowLabel(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).isShowLabel();
    }

    public Font getSliceLabelFont(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).getLabelFont();
    }

    public String getSliceLabelFormat(RmaDataId sliceId) {
        return this.replaceAttributeFormat(((PieSliceRenderControls)this._controls.getItemControls()).getLabelFormat(), FormatContext.SLICE, sliceId);
    }

    public Color getSliceLabelColor(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).getLabelColor();
    }

    public boolean isSliceShowValue(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).isShowValue();
    }

    public boolean isSliceShowThresholds(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).isShowThresholds();
    }

    public List<Threshold> getSliceThresholds(RmaDataId sliceId) {
        return ((PieSliceRenderControls)this._controls.getItemControls()).getThresholds();
    }

    public double getArcAngle(RmaDataId sliceId) {
        double arcAngle = 360.0 * this.getSliceMaxValue(sliceId) / this.getTotalMaxValue();
        return this.isDrawClockwise() ? -1.0 * arcAngle : arcAngle;
    }

    private String replaceAttributeFormat(String format, FormatContext context, RmaDataId slice) {
        String retStr = format;
        int replaceIndex = retStr.indexOf("<%");
        int endReplaceIndex = retStr.indexOf("%>", replaceIndex);
        while (replaceIndex != -1 && endReplaceIndex != -1) {
            String formatReplace;
            switch (formatReplace = retStr.substring(replaceIndex, endReplaceIndex + 2)) {
                case "<%Name%>": {
                    retStr = this.doNameFormat(retStr, context, slice);
                    break;
                }
                case "<%Location%>": {
                    retStr = this.doLocationFormat(retStr, context, slice);
                    break;
                }
                case "<%Description%>": {
                    retStr = this.doDescriptionFormat(retStr, context, slice);
                    break;
                }
                case "<%Date%>": {
                    retStr = this.doDateFormat(retStr);
                    break;
                }
                case "<%Portion%>": {
                    retStr = this.doPortionFormat(retStr, context, slice);
                    break;
                }
                case "<%Fill%>": {
                    retStr = this.doFillFormat(retStr, context, slice);
                    break;
                }
                case "<%Value%>": {
                    retStr = this.doValueFormat(retStr, context, slice);
                    break;
                }
                case "<%MinValue%>": {
                    retStr = this.doMinValueFormat(retStr, context, slice);
                    break;
                }
                case "<%MaxValue%>": {
                    retStr = this.doMaxValueFormat(retStr, context, slice);
                    break;
                }
                case "<%RelativeValue%>": {
                    retStr = this.doRelativeValueFormat(retStr, context, slice);
                    break;
                }
                case "<%RelativeMax%>": {
                    retStr = this.doRelativeMaxFormat(retStr, context, slice);
                    break;
                }
                case "<%Quality%>": {
                    retStr = this.doQualityFormat(retStr, context, slice);
                    break;
                }
                case "<%Units%>": {
                    retStr = this.doUnitsFormat(retStr, context, slice);
                    break;
                }
            }
            replaceIndex = retStr.indexOf("<%", replaceIndex + 2);
            endReplaceIndex = retStr.indexOf("%>", replaceIndex);
        }
        return retStr;
    }

    private String doNameFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(NAME_FORMAT, this._model.getId().getName()) : format.replaceAll(NAME_FORMAT, slice.getName());
    }

    private String doLocationFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(LOCATION_FORMAT, this._model.getId().getLocation()) : format.replaceAll(LOCATION_FORMAT, slice.getLocation());
    }

    private String doDescriptionFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(DESCRIPTION_FORMAT, this._model.getId().getDescription()) : format.replaceAll(DESCRIPTION_FORMAT, slice.getDescription());
    }

    private String doDateFormat(String format) {
        return format.replaceAll(DATE_FORMAT, this._currentTime.toString());
    }

    private String doPortionFormat(String format, FormatContext context, RmaDataId slice) {
        double portionValue = context == FormatContext.CHART ? this.getTotalValue() / this.getTotalMaxValue() : this.getSliceMaxValue(slice) / this.getTotalMaxValue();
        return format.replaceAll(PORTION_FORMAT, String.valueOf(this.round(portionValue * 100.0)) + "%");
    }

    private String doFillFormat(String format, FormatContext context, RmaDataId slice) {
        double val;
        double min;
        double max;
        if (context == FormatContext.CHART) {
            max = this.getTotalMaxValue();
            min = this.getTotalMinValue();
            val = this.getTotalValue();
        } else {
            max = this.getSliceMaxValue(slice);
            min = this.getSliceMinValue(slice);
            val = this.getSliceValue(slice);
        }
        double fillValue = (val - min) / (max - min);
        return format.replaceAll(FILL_FORMAT, String.valueOf(this.round(fillValue * 100.0)) + "%");
    }

    private String doValueFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(VALUE_FORMAT, String.valueOf(this.round(this.getTotalValue()))) : format.replaceAll(VALUE_FORMAT, String.valueOf(this.round(this.getSliceValue(slice))));
    }

    private String doMinValueFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(MIN_VALUE_FORMAT, String.valueOf(this.round(this.getTotalMinValue()))) : format.replaceAll(MIN_VALUE_FORMAT, String.valueOf(this.round(this.getSliceMinValue(slice))));
    }

    private String doMaxValueFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(MAX_VALUE_FORMAT, String.valueOf(this.round(this.getTotalMaxValue()))) : format.replaceAll(MAX_VALUE_FORMAT, String.valueOf(this.round(this.getSliceMaxValue(slice))));
    }

    private String doRelativeValueFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(RELATIVE_VALUE_FORMAT, String.valueOf(this.round(this.getTotalRelativeValue()))) : format.replaceAll(RELATIVE_VALUE_FORMAT, String.valueOf(this.round(this.getSliceRelativeValue(slice))));
    }

    private String doRelativeMaxFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(RELATIVE_MAX_FORMAT, String.valueOf(this.round(this.getTotalRelativeMax()))) : format.replaceAll(RELATIVE_MAX_FORMAT, String.valueOf(this.round(this.getSliceRelativeMax(slice))));
    }

    private String doQualityFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(QUALITY_FORMAT, String.valueOf(this.round(this.getQuality()))) : format.replaceAll(QUALITY_FORMAT, String.valueOf(this.round(this.getSliceQuality(slice))));
    }

    private String doUnitsFormat(String format, FormatContext context, RmaDataId slice) {
        return context == FormatContext.CHART ? format.replaceAll(UNITS_FORMAT, this.getUnits()) : format.replaceAll(UNITS_FORMAT, this.getSliceUnits(slice));
    }

    public Color createMixture(Color c1, Color c2, float p) {
        p = p <= 0.5f ? (p *= 2.0f) : (p - 0.5f) * 2.0f;
        float alpha = this.ave(c1.getAlpha(), c2.getAlpha(), p);
        float red = this.ave(c1.getRed(), c2.getRed(), p);
        float green = this.ave(c1.getGreen(), c2.getGreen(), p);
        float blue = this.ave(c1.getBlue(), c2.getBlue(), p);
        return new Color(red, green, blue, alpha);
    }

    private float ave(int start, int end, float p) {
        return (float)(start + Math.round(p * (float)(end - start))) / 255.0f;
    }

    public boolean isTitleVisible() {
        return this._controls.isTitleVisible();
    }

    public boolean isFooterVisible() {
        return this._controls.isFooterVisible();
    }

    public boolean isSubtitleVisible() {
        return this._controls.isSubtitleVisible();
    }

    public boolean isRadialSumTextVisible() {
        return this._controls.isRadialSumTextVisible();
    }

    private class KeyAction
    extends AbstractAction {
        public KeyAction(String actionCommand) {
            this.putValue("ActionCommandKey", actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (actionEvent.getActionCommand()) {
                case "VK_ESCAPE": {
                    PieChartPanel.this.handleKeyEscape();
                    break;
                }
                case "VK_UP": {
                    PieChartPanel.this.handleKeyDown();
                    break;
                }
                case "VK_DOWN": {
                    PieChartPanel.this.handleKeyUp();
                    break;
                }
                case "VK_LEFT": {
                    PieChartPanel.this.handleKeyDown();
                    break;
                }
                case "VK_RIGHT": {
                    PieChartPanel.this.handleKeyUp();
                }
            }
        }
    }

    private static enum FormatContext {
        CHART,
        SLICE;

    }
}

