/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.pie;

import hec.gfx2d.swing.charts.color.ColorContourType;
import hec.gfx2d.swing.charts.data.ChartItemRenderControls;
import hec.gfx2d.swing.charts.data.ChartRenderControls;
import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.gfx2d.swing.charts.pie.PieSliceRenderControls;
import hec.gfx2d.swing.charts.thresholds.Threshold;
import hec.gfx2d.swing.charts.util.AngleOption;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import rma.util.BandedColorContour;
import rma.util.Clipping;
import rma.util.contour.ColorContourRecord;
import rma.util.contour.PieChartColorContourRecord;
import rma.util.lookup.Lookup;
import rma.xml.adapters.XmlColorContourRecordAdapter;

@XmlRootElement(name="PieChartRenderControls")
@XmlAccessorType(value=XmlAccessType.NONE)
public class PieChartRenderControls
extends ChartRenderControls<PieSliceRenderControls>
implements Serializable {
    public static final String PROPERTY_START_ANGLE = "rmaChartRenderControls.startAngle";
    public static final String PROPERTY_START_ANGLE_MEASURE = "rmaChartRenderControls.startAngleMeasure";
    public static final String PROPERTY_DRAW_CLOCKWISE = "rmaChartRenderControls.drawClockwise";
    public static final String PROPERTY_SHOW_RADIAL_SUM = "rmaChartRenderControls.showRadialSum";
    public static final String PROPERTY_RADIAL_SUM_TEXT_VISIBLE = "rmaChartRenderControls.radialSumTextVisible";
    public static final String PROPERTY_SINGLE_COLOR_SUM = "rmaChartRenderControls.singleColorSum";
    public static final String PROPERTY_RADIAL_SUM_CONTOUR = "rmaChartRenderControls.radialSumContour";
    public static final String PROPERTY_RADIAL_SUM_CONTOUR_TYPE = "rmaChartRenderControls.radialSumContourType";
    @XmlElement(name="drawClockwise")
    private boolean _drawClockwise;
    @XmlElement(name="startAngle")
    private double _startAngle;
    @XmlElement(name="startAngleMeasure")
    private AngleOption _startAngleMeasure;
    @XmlElement(name="showRadialSum")
    private boolean _showRadialSum;
    @XmlElement(name="radialSumTextVisible")
    private boolean _radialSumTextVisible;
    @XmlElement(name="singleColorSum")
    private boolean _singleColorSum;
    @XmlElement(name="radialSumContour")
    @XmlJavaTypeAdapter(value=XmlColorContourRecordAdapter.class)
    private ColorContourRecord _radialSumContour;
    @XmlElement(name="radialSumContourType")
    private ColorContourType _radialSumContourType;

    private PieChartRenderControls() {
        super(null);
    }

    public PieChartRenderControls(RmaDataId id) {
        super(id);
        this._itemControls = new PieSliceRenderControls();
        this._drawClockwise = true;
        this._startAngle = 90.0;
        this._startAngleMeasure = AngleOption.DEGREES;
        this._showRadialSum = false;
        this._singleColorSum = true;
        BandedColorContour defaultContour = new BandedColorContour();
        defaultContour.setColorAtIndex(0.0, Color.CYAN);
        defaultContour.setColorAtIndex(25.0, Color.YELLOW);
        defaultContour.setColorAtIndex(75.0, Color.MAGENTA);
        defaultContour.setMinValue(0.0);
        defaultContour.setMaxValue(100.0);
        Clipping maxClipping = new Clipping();
        maxClipping.setValue(100.0);
        Clipping minClipping = new Clipping();
        minClipping.setValue(0.0);
        defaultContour.setMaxClipping(maxClipping);
        defaultContour.setMinClipping(minClipping);
        this._radialSumContour = new PieChartColorContourRecord(defaultContour, 0.5f, 10.0);
        this._radialSumContourType = ColorContourType.BANDED;
    }

    public PieChartRenderControls(RmaDataId id, PieSliceRenderControls itemControls) {
        this(id);
        this.setItemControls(itemControls);
    }

    public void copy(PieChartRenderControls controls) {
        super.copy(controls);
        this._drawClockwise = controls.isDrawClockwise();
        this._startAngle = controls.getStartAngle();
        this._startAngleMeasure = controls.getStartAngleMeasure();
        this._showRadialSum = controls.isShowRadialSum();
        this._singleColorSum = controls.isSingleColorSum();
        this._radialSumContour = controls.getRadialSumContour();
        this._radialSumContourType = controls.getRadialSumContourType();
    }

    public boolean isDrawClockwise() {
        return this._drawClockwise;
    }

    public void setDrawClockwise(boolean drawClockwise) {
        boolean oldVal = this._drawClockwise;
        this._drawClockwise = drawClockwise;
        this.fireUpdate(PROPERTY_DRAW_CLOCKWISE, oldVal, drawClockwise);
    }

    public double getStartAngle() {
        return this._startAngle;
    }

    public void setStartAngle(double startAngle) {
        double oldVal = this._startAngle;
        this._startAngle = startAngle;
        this.fireUpdate(PROPERTY_START_ANGLE, oldVal, startAngle);
    }

    public void setStartAngle(double startAngle, AngleOption measure) {
        this._startAngle = startAngle;
        this._startAngleMeasure = measure;
        this.fireUpdate();
    }

    public AngleOption getStartAngleMeasure() {
        return this._startAngleMeasure;
    }

    public void setStartAngleMeasure(AngleOption measure) {
        AngleOption oldVal = this._startAngleMeasure;
        this._startAngleMeasure = measure;
        this.fireUpdate(PROPERTY_START_ANGLE_MEASURE, (Object)oldVal, (Object)measure);
    }

    public boolean isShowRadialSum() {
        return this._showRadialSum;
    }

    public void setShowRadialSum(boolean showRadialSum) {
        boolean oldVal = this._showRadialSum;
        this._showRadialSum = showRadialSum;
        this.fireUpdate(PROPERTY_SHOW_RADIAL_SUM, oldVal, showRadialSum);
    }

    public boolean isSingleColorSum() {
        return this._singleColorSum;
    }

    public void setSingleColorSum(boolean singleColorSum) {
        boolean oldVal = this._singleColorSum;
        this._singleColorSum = singleColorSum;
        this.fireUpdate(PROPERTY_SINGLE_COLOR_SUM, oldVal, singleColorSum);
    }

    public ColorContourRecord getRadialSumContour() {
        return this._radialSumContour;
    }

    public void setRadialSumContour(ColorContourRecord contour) {
        ColorContourRecord oldVal = this._radialSumContour;
        this._radialSumContour = contour;
        this.fireUpdate(PROPERTY_RADIAL_SUM_CONTOUR, oldVal, contour);
    }

    public ColorContourType getRadialSumContourType() {
        return this._radialSumContourType;
    }

    public void setRadialSumContourType(ColorContourType contourType) {
        ColorContourType oldVal = this._radialSumContourType;
        this._radialSumContourType = contourType;
        this.fireUpdate(PROPERTY_RADIAL_SUM_CONTOUR_TYPE, (Object)oldVal, (Object)contourType);
    }

    public static PieChartRenderControls jaxbCreateTask() {
        return new PieChartRenderControls();
    }

    @Override
    public String toXml() {
        try {
            Collection<Class> classes = this.getJaxbClasses();
            Class[] classesArray = classes.toArray(new Class[classes.size()]);
            JAXBContext contextObj = JAXBContext.newInstance((Class[])classesArray);
            Marshaller marshallerObj = contextObj.createMarshaller();
            marshallerObj.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter writer = new StringWriter();
            marshallerObj.marshal((Object)this, (Writer)writer);
            return writer.getBuffer().toString();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public PieChartRenderControls fromXml(String buildStr) {
        if (buildStr != null) {
            try {
                Collection<Class> classes = this.getJaxbClasses();
                Class[] classesArray = classes.toArray(new Class[classes.size()]);
                JAXBContext contextObj = JAXBContext.newInstance((Class[])classesArray);
                Unmarshaller unMarshallerObj = contextObj.createUnmarshaller();
                return (PieChartRenderControls)unMarshallerObj.unmarshal((Source)new StreamSource(new StringReader(buildStr)));
            }
            catch (JAXBException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private Collection<Class> getJaxbClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.addAll(this.getHardCodedClasses());
        classes.addAll(this.getLookupClasses());
        return classes;
    }

    private Collection<Class> getHardCodedClasses() {
        ArrayList<Class> retVal = new ArrayList<Class>();
        retVal.add(ChartRenderControls.class);
        retVal.add(ChartItemRenderControls.class);
        retVal.add(PieChartRenderControls.class);
        retVal.add(PieSliceRenderControls.class);
        retVal.add(RmaDataId.class);
        retVal.add(Threshold.class);
        return retVal;
    }

    private Collection<Class> getLookupClasses() {
        ArrayList<Class> retVal = new ArrayList<Class>();
        Collection extra = Lookup.getDefault().lookupAll(PieSliceRenderControls.class);
        if (extra != null) {
            for (PieSliceRenderControls controls : extra) {
                retVal.add(controls.getClass());
            }
        }
        return retVal;
    }

    public boolean isRadialSumTextVisible() {
        return this._radialSumTextVisible;
    }

    public void setRadialSumTextVisible(boolean _radialSumTextVisible) {
        this._radialSumTextVisible = _radialSumTextVisible;
    }
}

