/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.pie;

import hec.gfx2d.swing.charts.color.ColorContourType;
import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.gfx2d.swing.charts.data.ThresholdLineStyle;
import hec.gfx2d.swing.charts.pie.PieChartPanel;
import hec.gfx2d.swing.charts.pie.PieSliceView;
import hec.gfx2d.swing.charts.thresholds.Threshold;
import hec.gfx2d.swing.charts.util.AngleOption;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import rma.util.BandedColorContour;
import rma.util.ColorContour;
import rma.util.FillPatternFactory;
import rma.util.contour.ColorContourRecord;

public class PieChartView
extends JPanel {
    private final PieChartPanel _controller;
    private int _selectedIndex = -1;
    private static final int RADIUS_INSET = 70;
    private static final int NO_LABELS_RADIUS_INSET = 50;

    PieChartView(PieChartPanel controller) {
        this._controller = controller;
        super.setBackground(Color.WHITE);
    }

    private List<PieSliceView> getSlices() {
        ArrayList<PieSliceView> output = new ArrayList<PieSliceView>();
        output.addAll(this._controller.getSlices());
        return output;
    }

    public PieSliceView getSlice(RmaDataId sliceId) {
        PieSliceView retSlice = null;
        for (PieSliceView slice : this.getSlices()) {
            if (!slice.getId().equals(sliceId)) continue;
            retSlice = slice;
            break;
        }
        return retSlice;
    }

    public void setSelectedSlice(RmaDataId sliceId) {
        int oldIndex = this._selectedIndex;
        for (PieSliceView slice : this.getSlices()) {
            if (slice.getId().equals(sliceId) && this._controller.isSliceVisible(slice.getId())) {
                slice.setSelected(true);
                this._selectedIndex = this.getSlices().indexOf(slice);
                continue;
            }
            slice.setSelected(false);
        }
        if (oldIndex == this._selectedIndex) {
            this.clearSelectedSlice();
        }
    }

    public void clearSelectedSlice() {
        for (PieSliceView slice : this.getSlices()) {
            slice.setSelected(false);
        }
        this._selectedIndex = -1;
    }

    public void handleKeyUp() {
        if (this._selectedIndex >= 0 && this._selectedIndex < this.getSlices().size()) {
            this.getSlices().get(this._selectedIndex).setSelected(false);
        }
        ++this._selectedIndex;
        if (this._selectedIndex >= this.getSlices().size()) {
            this._selectedIndex = this.getSlices().size() - 1;
        }
        this.getSlices().get(this._selectedIndex).setSelected(true);
    }

    public void handleKeyDown() {
        if (this._selectedIndex >= 0 && this._selectedIndex < this.getSlices().size()) {
            this.getSlices().get(this._selectedIndex).setSelected(false);
        }
        --this._selectedIndex;
        if (this._selectedIndex < 0) {
            this._selectedIndex = 0;
        }
        this.getSlices().get(this._selectedIndex).setSelected(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.draw(g2d, this.getBounds());
    }

    protected void draw(Graphics2D g2d, Rectangle area) {
        g2d.setColor(this.getBackground());
        g2d.fill(area);
        Point2D.Double center = new Point2D.Double(area.width / 2, area.height / 2);
        double maxRadius = Math.min(((Point2D)center).getX(), ((Point2D)center).getY());
        this.drawSlicesAndLabels(g2d, center, maxRadius -= this.areSliceLabelsVisible() ? 70.0 : 50.0, area);
        this.drawSliceThresholds(g2d, center, maxRadius);
        this.drawSliceValues(g2d, center, maxRadius);
        this.drawBoundaries(g2d, center, maxRadius);
        this.drawThresholdsAndLabels(g2d, center, maxRadius);
        this.drawRadialSum(g2d, center, maxRadius, area);
        this.drawSelection(g2d, center, maxRadius);
    }

    protected boolean areSliceLabelsVisible() {
        boolean output = false;
        for (PieSliceView _slice : this.getSlices()) {
            if (!this._controller.isSliceShowLabel(_slice.getId())) continue;
            output = true;
            break;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawSlicesAndLabels(Graphics g, Point2D center, double maxRadius, Rectangle area) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            double labelY;
            double labelX;
            Rectangle2D rc2d;
            double startAngle = this._controller.getStartAngle();
            if (this._controller.getStartAngleMeasure() == AngleOption.RADIANS) {
                startAngle = Math.toDegrees(startAngle);
            }
            double currentAngle = startAngle;
            GraphicsConfiguration graphicsConfig = g2d.getDeviceConfiguration();
            BufferedImage pieSliceBuffImage = graphicsConfig.createCompatibleImage(area.width, area.height, 3);
            Graphics2D maskAndFillG2D = pieSliceBuffImage.createGraphics();
            maskAndFillG2D.setComposite(AlphaComposite.Clear);
            maskAndFillG2D.fillRect(0, 0, area.width, area.height);
            maskAndFillG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (PieSliceView sliceView : this.getSlices()) {
                if (!this._controller.isSliceVisible(sliceView.getId())) continue;
                double arcAngle = this._controller.getArcAngle(sliceView.getId());
                sliceView.drawSlice(maskAndFillG2D, center, maxRadius, currentAngle, arcAngle, this._controller);
                sliceView.drawSliceLabel(maskAndFillG2D, center, maxRadius, currentAngle, arcAngle, this._controller);
                currentAngle += arcAngle;
            }
            maskAndFillG2D.dispose();
            g2d.drawImage(pieSliceBuffImage, new AffineTransform(), null);
            double titleLabelY = 0.0;
            if (this._controller.isTitleVisible()) {
                g2d.setColor(this._controller.getTitleColor());
                g2d.setFont(this._controller.getTitleFont());
                FontMetrics metrics = g2d.getFontMetrics();
                rc2d = metrics.getStringBounds(this._controller.getTitleFormat(), g2d);
                labelX = center.getX() - rc2d.getWidth() / 2.0;
                titleLabelY = rc2d.getHeight() + (double)metrics.getMaxDescent();
                g2d.drawString(this._controller.getTitleFormat(), (int)Math.round(labelX), (int)Math.round(titleLabelY));
            }
            if (this._controller.isSubtitleVisible()) {
                g2d.setColor(this._controller.getSubtitleColor());
                g2d.setFont(this._controller.getSubtitleFont());
                FontMetrics metrics = g2d.getFontMetrics();
                rc2d = metrics.getStringBounds(this._controller.getSubtitleFormat(), g2d);
                labelX = center.getX() - rc2d.getWidth() / 2.0;
                labelY = titleLabelY + rc2d.getHeight() / 2.0 + (double)(metrics.getMaxDescent() * 2);
                g2d.drawString(this._controller.getSubtitleFormat(), (int)Math.round(labelX), (int)Math.round(labelY));
            }
            if (this._controller.isFooterVisible()) {
                g2d.setColor(this._controller.getFooterColor());
                g2d.setFont(this._controller.getFooterFont());
                FontMetrics metrics = g2d.getFontMetrics();
                rc2d = metrics.getStringBounds(this._controller.getFooterFormat(), g2d);
                labelX = center.getX() - rc2d.getWidth() / 2.0;
                labelY = (double)this.getHeight() - (rc2d.getHeight() + (double)metrics.getMaxDescent());
                g2d.drawString(this._controller.getFooterFormat(), (int)Math.round(labelX), (int)Math.round(labelY));
            }
        }
        finally {
            g2d.dispose();
        }
    }

    protected void drawSliceThresholds(Graphics2D g2d, Point2D center, double maxRadius) {
        double startAngle = this._controller.getStartAngle();
        if (this._controller.getStartAngleMeasure() == AngleOption.RADIANS) {
            startAngle = Math.toDegrees(startAngle);
        }
        for (PieSliceView sliceView : this.getSlices()) {
            if (!this._controller.isSliceVisible(sliceView.getId())) continue;
            double arcAngle = this._controller.getArcAngle(sliceView.getId());
            sliceView.drawRadialMarksAndLabels(g2d, center, maxRadius, startAngle, arcAngle, this._controller);
            startAngle += arcAngle;
        }
    }

    protected void drawSliceValues(Graphics2D g2d, Point2D center, double maxRadius) {
        double startAngle = this._controller.getStartAngle();
        if (this._controller.getStartAngleMeasure() == AngleOption.RADIANS) {
            startAngle = Math.toDegrees(startAngle);
        }
        for (PieSliceView sliceView : this.getSlices()) {
            if (!this._controller.isSliceVisible(sliceView.getId())) continue;
            double arcAngle = this._controller.getArcAngle(sliceView.getId());
            sliceView.drawValueMarksAndLabels(g2d, center, maxRadius, startAngle, arcAngle, this._controller);
            startAngle += arcAngle;
        }
    }

    protected void drawBoundaries(Graphics2D g2d, Point2D center, double maxRadius) {
        double startAngle = this._controller.getStartAngle();
        if (this._controller.getStartAngleMeasure() == AngleOption.RADIANS) {
            startAngle = Math.toDegrees(startAngle);
        }
        for (PieSliceView sliceView : this.getSlices()) {
            if (!this._controller.isSliceVisible(sliceView.getId())) continue;
            double arcAngle = this._controller.getArcAngle(sliceView.getId());
            float endX = (float)(center.getX() + maxRadius * Math.cos(Math.toRadians(startAngle)));
            float endY = (float)(center.getY() - maxRadius * Math.sin(Math.toRadians(startAngle)));
            g2d.setColor(Color.BLACK);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawLine((int)center.getX(), (int)center.getY(), Math.round(endX), Math.round(endY));
            startAngle += arcAngle;
        }
    }

    protected void drawThresholdsAndLabels(Graphics2D g2d, Point2D center, double maxRadius) {
        if (this._controller.isShowThresholds()) {
            for (Threshold radialMark : this._controller.getThresholds()) {
                if (!radialMark.isVisible()) continue;
                double mark = radialMark.getValue();
                if (radialMark.getType() == Threshold.ThresholdType.UNIT) {
                    double relativeMark = mark;
                    double range = this._controller.getTotalMaxValue();
                    mark = relativeMark / range;
                }
                double markRadius = maxRadius * mark;
                Ellipse2D.Double markCircle = new Ellipse2D.Double(center.getX() - markRadius, center.getY() - markRadius, markRadius * 2.0, markRadius * 2.0);
                this.drawThreshold(g2d, radialMark, center, maxRadius, markCircle);
                if (!this._controller.isShowThresholdText()) continue;
                String markString = radialMark.getLabelFormat(this._controller.getTotalMaxValue(), this._controller);
                g2d.setFont(radialMark.getLabelFont());
                Rectangle2D rc2d = g2d.getFontMetrics().getStringBounds(markString, g2d);
                g2d.setColor(Color.WHITE);
                g2d.fillRoundRect((int)(center.getX() - rc2d.getWidth() / 2.0 - 2.0), (int)(center.getY() - markRadius - rc2d.getHeight() / 2.0 + 2.0), (int)rc2d.getWidth() + 4, (int)rc2d.getHeight() + 4, 4, 4);
                g2d.setColor(radialMark.getLabelColor());
                g2d.drawString(markString, (int)(center.getX() - rc2d.getWidth() / 2.0), (int)(center.getY() - markRadius + rc2d.getHeight() / 2.0));
            }
        }
    }

    protected void drawRadialSum(Graphics2D g2d, Point2D center, double maxRadius, Rectangle2D rect) {
        if (this._controller.isShowRadialSum()) {
            double range;
            double relativeValue = this._controller.getTotalValue();
            double value = relativeValue / (range = this._controller.getTotalMaxValue());
            double valueRadius = maxRadius * value;
            double valueDrawRadius = valueRadius > maxRadius ? maxRadius : valueRadius;
            Ellipse2D.Double valueCircle = new Ellipse2D.Double(center.getX() - valueDrawRadius, center.getY() - valueDrawRadius, valueDrawRadius * 2.0, valueDrawRadius * 2.0);
            if (valueDrawRadius > 0.0) {
                this.establishRadialSumContour(g2d, center, valueRadius, maxRadius);
                g2d.fill(valueCircle);
            }
            float[] dash1 = new float[]{10.0f};
            g2d.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f));
            g2d.setColor(Color.DARK_GRAY);
            g2d.draw(valueCircle);
            if (this._controller.isRadialSumTextVisible()) {
                double markValue = this._controller.getTotalValue();
                String markString = this._controller.round(this._controller.getTotalMinValue()) + " / " + this._controller.round(markValue) + " / " + this._controller.round(this._controller.getTotalMaxValue());
                g2d.setFont(this._controller.getSubtitleFont());
                Rectangle2D rc2d = g2d.getFontMetrics().getStringBounds(markString, g2d);
                g2d.setColor(Color.WHITE);
                g2d.fillRoundRect((int)(center.getX() - rc2d.getWidth() / 2.0 - 2.0), (int)(center.getY() - valueDrawRadius - rc2d.getHeight() / 2.0 + 2.0), (int)rc2d.getWidth() + 4, (int)rc2d.getHeight() + 4, 4, 4);
                g2d.setColor(Color.DARK_GRAY);
                g2d.drawString(markString, (int)(center.getX() - rc2d.getWidth() / 2.0), (int)(center.getY() - valueDrawRadius + rc2d.getHeight() / 2.0));
            }
        }
    }

    protected void drawSelection(Graphics2D g2d, Point2D center, double maxRadius) {
        for (PieSliceView slice : this.getSlices()) {
            slice.drawSelected(g2d, this._controller);
        }
    }

    protected void drawThreshold(Graphics2D g2d, Threshold threshold, Point2D center, double maxRadius, Ellipse2D markCircle) {
        ThresholdLineStyle lineProperties = threshold.getLineProperties();
        Color lineColor = lineProperties.getLineColor();
        Color lineFColor = lineProperties.getFillColor();
        float[] linePattern = lineProperties.getLineStyle();
        if (linePattern.length == 1 && linePattern[0] == 50.0f) {
            linePattern = null;
        }
        float lineThickness = lineProperties.getLineWeight();
        Color oldColor = g2d.getColor();
        if (lineProperties.isDrawLine()) {
            int fillType = lineProperties.getFillPattern();
            if (fillType == 0) {
                g2d.setColor(new Color((float)lineFColor.getRed() / 255.0f, (float)lineFColor.getGreen() / 255.0f, (float)lineFColor.getBlue() / 255.0f, 0.75f));
                if (lineProperties.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.BELOW) {
                    g2d.fill(markCircle);
                } else if (lineProperties.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.ABOVE) {
                    Ellipse2D.Double maxRing = new Ellipse2D.Double(center.getX() - maxRadius, center.getY() - maxRadius, maxRadius * 2.0, maxRadius * 2.0);
                    Area markRing = new Area(maxRing);
                    markRing.subtract(new Area(markCircle));
                    g2d.fill(markRing);
                }
            } else {
                Composite oldAc = g2d.getComposite();
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                Paint op = g2d.getPaint();
                Paint tp = FillPatternFactory.createFillPattern(fillType, lineFColor);
                g2d.setPaint(tp);
                g2d.setComposite(ac);
                if (lineProperties.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.BELOW) {
                    g2d.fill(markCircle);
                } else if (lineProperties.getFillStyle() == ThresholdLineStyle.ThresholdFillStyle.ABOVE) {
                    Ellipse2D.Double maxRing = new Ellipse2D.Double(center.getX() - maxRadius, center.getY() - maxRadius, maxRadius * 2.0, maxRadius * 2.0);
                    Area markRing = new Area(maxRing);
                    markRing.subtract(new Area(markCircle));
                    g2d.fill(markRing);
                }
                g2d.setComposite(oldAc);
                g2d.setPaint(op);
            }
            g2d.setColor(lineColor);
            Stroke oldStroke = g2d.getStroke();
            BasicStroke bs = new BasicStroke(lineThickness, 0, 0, 10.0f, linePattern, 0.0f);
            g2d.setStroke(bs);
            g2d.draw(markCircle);
            g2d.setStroke(oldStroke);
        }
        g2d.setColor(oldColor);
    }

    private void establishRadialSumContour(Graphics2D g2d, Point2D center, double valueRadius, double maxRadius) {
        int minValue;
        int maxValue;
        ColorContourRecord contourRecord = this._controller.getRadialSumContour();
        ColorContour contour = contourRecord.getColorContour();
        boolean singleColor = this._controller.isSingleColorSum();
        int percentFull = (int)Math.round(valueRadius / maxRadius * 100.0);
        if (this._controller.getRadialSumContourType() == ColorContourType.BANDED) {
            BandedColorContour bandedContour = (BandedColorContour)contour;
            maxValue = singleColor ? this._controller.getBandedContourMax(bandedContour) : 100;
            minValue = singleColor ? this._controller.getBandedContourMin(bandedContour) : 0;
        } else {
            maxValue = (int)contour.getMaxValue();
            minValue = (int)contour.getMinValue();
        }
        if (percentFull > maxValue) {
            percentFull = maxValue;
        } else if (percentFull < minValue) {
            percentFull = minValue;
        }
        if (singleColor) {
            g2d.setColor(this.buildSingleColorFromContour(percentFull, contour, contourRecord));
        } else {
            g2d.setPaint(this.buildGradientFromContour(center, 100, maxRadius, contour, contourRecord));
        }
    }

    private Color buildSingleColorFromContour(int percentFull, ColorContour contour, ColorContourRecord contourRecord) {
        Color radialColor = contour.getColor(percentFull);
        float red = (float)radialColor.getRed() / 255.0f;
        float green = (float)radialColor.getGreen() / 255.0f;
        float blue = (float)radialColor.getBlue() / 255.0f;
        return new Color(red, green, blue, contourRecord.getAlpha());
    }

    private RadialGradientPaint buildGradientFromContour(Point2D center, int percentFull, double maxRadius, ColorContour contour, ColorContourRecord record) {
        int steps = percentFull;
        if (steps < 2) {
            steps = 2;
        } else if (steps > 100) {
            steps = 100;
        }
        double resolutionIncreaseForPrecision = 2.0;
        steps = (int)((double)steps * resolutionIncreaseForPrecision);
        Color[] contourColorsForDistances = new Color[steps];
        float[] distancesForContourColors = new float[steps];
        double currentDistance = 1.0;
        double distanceStep = 1.0 / (double)steps;
        for (int percentIdx = steps - 1; percentIdx >= 0; --percentIdx) {
            double percentIndexCorrected = percentIdx + 1;
            Color color = contour.getColor(percentIndexCorrected / resolutionIncreaseForPrecision);
            contourColorsForDistances[percentIdx] = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(record.getAlpha() * 255.0f));
            distancesForContourColors[percentIdx] = (float)currentDistance;
            currentDistance -= distanceStep;
        }
        return new RadialGradientPaint(center, (float)maxRadius, distancesForContourColors, contourColorsForDistances);
    }
}

