/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.pie;

import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.gfx2d.swing.charts.pie.PieChartPanel;
import hec.gfx2d.swing.charts.pie.PieSliceView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class PieLegendItemView {
    private final RmaDataId _id;
    private RoundRectangle2D _displayBox;
    private boolean _selected = false;
    private static final int BOX_INSET = 4;
    private static final int ARCW = 8;
    private static final int ARCH = 8;

    public PieLegendItemView(RmaDataId id) {
        this._id = id;
        this._displayBox = null;
    }

    public RmaDataId getId() {
        return this._id;
    }

    public void setSelected(boolean selected) {
        this._selected = selected;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public boolean contains(Point2D point) {
        return this._displayBox != null && this._displayBox.contains(point);
    }

    protected void drawItem(Graphics2D g2d, double x, double y, double width, double height, double startAngle, double arcAngle, PieChartPanel controller) {
        String labelStr = this.getId().getName();
        boolean visible = controller.isSliceVisible(this.getId());
        this._displayBox = new RoundRectangle2D.Double(x, y, width, height, 8.0, 8.0);
        g2d.setColor(visible ? Color.WHITE : Color.DARK_GRAY.brighter().brighter());
        g2d.fill(this._displayBox);
        if (visible) {
            if (this._selected) {
                g2d.setColor(Color.BLACK);
                g2d.draw(this._displayBox);
            }
            labelStr = controller.getSliceLabelFormat(this.getId());
            double arcX = x + 4.0;
            double arcY = y + 4.0;
            double arc = height - 8.0;
            double maxRadius = arc / 2.0;
            Point2D.Double center = new Point2D.Double(arcX + maxRadius, arcY + maxRadius);
            PieSliceView sliceView = controller.getChartView().getSlice(this.getId());
            sliceView.drawSliceMask(g2d, center, maxRadius, startAngle, arcAngle, controller);
            sliceView.drawSliceColor(g2d, center, maxRadius, startAngle, arcAngle, controller);
        }
        g2d.setFont(controller.getSliceLabelFont(this.getId()));
        Rectangle2D rc2d = g2d.getFontMetrics().getStringBounds(labelStr, g2d);
        int textX = (int)Math.round(x + height);
        int textY = (int)Math.round(y + rc2d.getHeight());
        g2d.setColor(controller.getSliceLabelColor(this.getId()));
        g2d.drawString(labelStr, textX, textY);
    }
}

