/*
 * Decompiled with CFR 0.152.
 */
package hec.gfx2d.swing.charts.pie;

import hec.gfx2d.swing.charts.data.RmaDataId;
import hec.gfx2d.swing.charts.pie.PieChartPanel;
import hec.gfx2d.swing.charts.pie.PieLegendItemView;
import hec.gfx2d.swing.charts.util.LegendSide;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class PieLegendView
extends JPanel {
    private List<PieLegendItemView> _legendItems = new ArrayList<PieLegendItemView>();
    private PieChartPanel _controller;
    private int _selectedIndex = -1;
    private static final int OFFSET = 4;

    public PieLegendView(PieChartPanel controller) {
        this._controller = controller;
        this.buildLegendItems();
    }

    private void buildLegendItems() {
        for (RmaDataId sliceId : this._controller.getSliceIds()) {
            this._legendItems.add(new PieLegendItemView(sliceId));
        }
    }

    public PieLegendItemView getItem(RmaDataId sliceId) {
        PieLegendItemView retItem = null;
        for (PieLegendItemView item : this._legendItems) {
            if (!item.getId().equals(sliceId)) continue;
            retItem = item;
            break;
        }
        return retItem;
    }

    public void setSelectedItem(RmaDataId itemId) {
        int oldIndex = this._selectedIndex;
        for (PieLegendItemView item : this._legendItems) {
            if (item.getId().equals(itemId) && this._controller.isSliceVisible(item.getId())) {
                item.setSelected(true);
                this._selectedIndex = this._legendItems.indexOf(item);
                continue;
            }
            item.setSelected(false);
        }
        if (oldIndex == this._selectedIndex) {
            this.clearSelectedItem();
        }
    }

    public void clearSelectedItem() {
        if (this._selectedIndex >= 0 && this._selectedIndex < this._legendItems.size()) {
            this._legendItems.get(this._selectedIndex).setSelected(false);
        }
        this._selectedIndex = -1;
    }

    public void handleKeyUp() {
        if (this._selectedIndex >= 0 && this._selectedIndex < this._legendItems.size()) {
            this._legendItems.get(this._selectedIndex).setSelected(false);
        }
        ++this._selectedIndex;
        if (this._selectedIndex >= this._legendItems.size()) {
            this._selectedIndex = this._legendItems.size() - 1;
        }
        this._legendItems.get(this._selectedIndex).setSelected(true);
    }

    public void handleKeyDown() {
        if (this._selectedIndex >= 0 && this._selectedIndex < this._legendItems.size()) {
            this._legendItems.get(this._selectedIndex).setSelected(false);
        }
        --this._selectedIndex;
        if (this._selectedIndex < 0) {
            this._selectedIndex = 0;
        }
        this._legendItems.get(this._selectedIndex).setSelected(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.draw(g2d, this.getBounds());
    }

    protected void draw(Graphics2D g2d, Rectangle area) {
        g2d.setBackground(Color.WHITE);
        double legendItemWidth = this.getWidestLegendItemWidth(g2d);
        double legendItemHeight = this.getTallestLegendItemHeight(g2d);
        int numRows = (int)(area.getHeight() / (legendItemHeight + 8.0));
        int numCols = (int)(area.getWidth() / (legendItemWidth + 8.0));
        if (this.isLegendHorizontal()) {
            numRows = this.minimizeRows(numRows, numCols);
            numCols = this.minimizeCols(numRows, numCols);
        } else {
            numCols = this.minimizeCols(numRows, numCols);
            numRows = this.minimizeRows(numRows, numCols);
        }
        double totalWidth = (legendItemWidth + 8.0) * (double)numCols;
        double totalHeight = (legendItemHeight + 8.0) * (double)numRows;
        double startX = area.getWidth() / 2.0 - totalWidth / 2.0;
        double startY = area.getHeight() / 2.0 - totalHeight / 2.0;
        this.drawLegendBox(g2d, startX, startY, totalWidth, totalHeight);
        this.drawLegendItems(g2d, startX, startY, legendItemWidth, legendItemHeight, numCols);
    }

    protected void drawLegendBox(Graphics2D g2d, double legendX, double legendY, double width, double height) {
        RoundRectangle2D.Double legendBox = new RoundRectangle2D.Double(legendX, legendY, width, height, 4.0, 4.0);
        g2d.setColor(Color.WHITE.darker());
        g2d.fill(legendBox);
    }

    protected void drawLegendItems(Graphics2D g2d, double startX, double startY, double width, double height, int cols) {
        double startAngle = this._controller.getStartAngle();
        int curRow = 0;
        int curCol = 0;
        for (PieLegendItemView itemView : this._legendItems) {
            double arcAngle = 0.0;
            if (this._controller.isSliceVisible(itemView.getId())) {
                arcAngle = this._controller.getArcAngle(itemView.getId());
            }
            double x = startX + (double)curCol * (width + 8.0) + 4.0;
            double y = startY + (double)curRow * (height + 8.0) + 4.0;
            itemView.drawItem(g2d, x, y, width, height, startAngle, arcAngle, this._controller);
            startAngle += arcAngle;
            if (++curCol < cols) continue;
            curCol = 0;
            ++curRow;
        }
    }

    protected double getWidestLegendItemWidth(Graphics2D g2d) {
        double maxWidth = 0.0;
        for (PieLegendItemView itemView : this._legendItems) {
            String labelStr = this._controller.getSliceLabelFormat(itemView.getId());
            g2d.setFont(this._controller.getSliceLabelFont(itemView.getId()));
            Rectangle2D rc2d = g2d.getFontMetrics().getStringBounds(labelStr, g2d);
            double width = 12.0 + rc2d.getHeight() + rc2d.getWidth();
            if (!(width > maxWidth)) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    protected double getTallestLegendItemHeight(Graphics2D g2d) {
        double maxHeight = 0.0;
        for (PieLegendItemView itemView : this._legendItems) {
            String labelStr = this._controller.getSliceLabelFormat(itemView.getId());
            g2d.setFont(this._controller.getSliceLabelFont(itemView.getId()));
            Rectangle2D rc2d = g2d.getFontMetrics().getStringBounds(labelStr, g2d);
            double height = rc2d.getHeight() + 8.0;
            if (!(height > maxHeight)) continue;
            maxHeight = height;
        }
        return maxHeight;
    }

    private boolean isLegendHorizontal() {
        return this._controller.getLegendSide() == LegendSide.TOP || this._controller.getLegendSide() == LegendSide.BOTTOM;
    }

    private int minimizeRows(int rows, int cols) {
        while (rows * cols >= this._legendItems.size()) {
            --rows;
        }
        return ++rows;
    }

    private int minimizeCols(int rows, int cols) {
        while (rows * cols >= this._legendItems.size()) {
            --cols;
        }
        return ++cols;
    }
}

